
| ⊕             | +      | ×       | ln    | Mem    |         |
|---------------|--------|---------|-------|--------|---------|
| u             | −      | N 2T A  | N2T A | −      | N 2T    |
| 2T            | N2T    | −       | −     | NT     |         |
| α             | N      |         |       |        |         |
| β             | N 2T   | N2T     | −     | −      | NT      |
| v             | −      | 2N 2T   | −     | −      | 1       |
| ln f          | −      | −       | −     | N 2T A | 1       |
| ln Z(x; θ)    | N      | −       | −     | −      | 1       |
| ln∇θm Z(x; θ) | N 2T A | N2T A   | −     | −      | M       |
| Asymptotical  | N 2T A | 2N 2T A | N2T A | N2T A  | N2T + M |

operations (recall that log-domain multiplication is defined as real addition) and the number of computed logarithms. The memory complexity is defined as the number of 32-bit registers needed to store variables during algorithm execution. The complexity expressions are simplified by taking the quantities in expressions to tend to infinity, and keeping only the leading terms. In discussion, we will use big O notation [7].

In applications, the feature functions f (yk−1, yk, x, k) map the input space for a fixed sequence x into sparse vectors, which has nonzero values only at positions

$$-1,y_{k})={\left\{\begin{array}{l l}{m}\end{array}\right.}$$

Ak(yk−1, yk) = { m ; fm(yk−1, yk, x, k) is nonzero }, (43)
which allows the complexity reduction by performing the computation only for nonzero elements. In our analysis we will use the average number of nonzero elements defined as

$$*\;J m$$
$\Sigma\subset\mathbb{R}^n$
$\mathbf{v}=\mathbf{r}$
$$A={\frac{\sum_{k=1}^{T}A_{k}(y_{k-1},y_{k})}{T}}.$$
T. (44)
As Table 1 shows, the computationally most demanding part of the algorithm is the termination phase, which requires O(N
2T A) log-additions (recall that one log-addition requires the computation of the exponent and logarithm). The memory complexity of the algorithm is O(N
2T + M), governed by the space needed for storing the matrices ui. The dependence of the memory complexity on the sequence length can significantly decrease computational performances of the algorithm if a long sequence is used, since it can cause overflows from the internal system memory to the disk storage, as shown in section 5.

The memory complexity can be reduced by the recomputation of the matrices uiin the backward pass (line 14)
and in the termination step (line 19), but this leads to the increased total number of additions and multiplications for 2N
2T A, while the memory complexity still depends on the sequence length since all forward and backward vectors need to be stored. The further improvement can be achieved if one notes that the backward vectors are computed during the termination step since they are used only once in line 19. In this case, each backward vector can be deleted after use in line 19 and all backward vectors can be stored at the memory location not depending on the sequence length. Then, the matrices ui can

$${\mathrm{to~}}\},$$

be recomputed only once in the termination step, where they are used for the computation of the backward vector but, again, all forward vectors need to be stored and the memory complexity is O(NT + M), still depending on the sequence length.

The problem of memory complexity of the forwardbackward algorithm for the HMM has already been studied by Khreich et al. in [14]. In this paper they have proposed the algorithm for the computation of marginal probabilities called forward filtering backward smoothing (*EFFBS*), which runs with the memory complexity independent of the sequence length, O(N), with the same asymptotical computational complexity as the standard forward-backward algorithm. However, the algorithm is based on the HMM assumption that the transition matrix is constant, and as such cannot be applied to CRFs.

Khreich et al. also gave a good review of the previously developed techniques for memory reduction such as checkpointing and forward-only algorithm, which try to reduce the memory complexity of the FB algorithm at the cost of computational overhead, and these techniques can be modified to deal with CRFs.

The checkpointing algorithm [11], [24] divides the input sequence into √T and during the forward pass only stores the first forward vector in each sub-sequence (checkpoint vectors).

In the backward pass, the forward values for each sub-sequence are sequentially recomputed, beginning with checkpoint vectors. In this way, the computational complexity required for the computation of the forward and backward vectors is increased to O(2T − N
2
√T), while the matrices ui should also be recomputed, which leads to greater total computational cost. On the other hand, the memory complexity, although reduced to O(N
√T), still depends on the sequence length.

In the forward-only algorithm [6], [14], [20], [22], the expression of the form is obtained from three-dimensional matrices which are recursively computed. For the HMM, the computation can be realized in the constant memory space independent of the sequence length O(N
2 +N) and with time complexity O(N
4T). However, if it is applied to the CRF, its time complexity increases to O(N
4MT), which is significantly slower than the FB algorithm.

In the following section we derive a forward-only algorithm which operates with the time complexity of order O(N
2(M +
A)T), while keeping the memory complexity independent of 5