the sequence length.

## 4. Log-Domain Expectation Semiring Forward Algorithm

In this section we consider a memory-efficient algorithm for CRF gradient computation which operates as a FB algorithm over an expectation semiring and develop its numerically stable log-domain version. In our previous work [13], we have developed the Entropy Message Passing EMP, which operates as a forward algorithm over the entropy semiring, which is the special case the expectation semiring. Although the algorithms presented in this paper are more general, in the following text they will be called the EMP, since they operate in the same manner as the algorithm from [13].

4.1. Expectation semiring forward algorithm Definition 4. *The expectation semiring of an order M is a tuple*
⟨ R × R
M, ⦶, ⊙, (0, 0), (1, 0) ⟩, where the operations ⦶ and
⊙ *are defined with:*

$$(z_{1},h_{1})\oplus(z_{2},h_{2})=(z_{1}+z_{2},h_{1}+h_{2}),\tag{45}$$ $$(z_{1},h_{1})\oplus(z_{2},h_{2})=(z_{1}z_{2},\ z_{1}h_{2}+z_{2}h_{1}),\tag{46}$$

for all (z1, h1), (z2, h2) *from* R×R
M, and 0 denotes zero vector.

The first component of an ordered pair is called a z-part, while the second one is an h-part.

For M = 1, the expectation semiring reduces to the entropy semiring considered in [13]. According to the addition rule, the z and h components of sum of two pairs are the sums of z and h components respectively, which gives us the following lemma.

Lemma 2. Let (zi, hi) ∈ R × R
M for all 1 ≤ i ≤ T. Then, the following equality holds in the expectation semiring:

$$\bigoplus_{i=1}^{T}(z_{i},z_{i}h_{i})={\Bigg(}\sum_{i=1}^{T}z_{i}\ ,\ \sum_{i=1}^{T}h_{i}\ {\Bigg)}.$$
hi ). (47)
Note that if the pairs have the form (z,zh), the multiplication acts as

$$(z_{1},h_{1})\odot(z_{2},h_{2})=(z_{1}z_{2},\ z_{1}z_{2}(h_{1}+h_{2}).$$

This can be generalized with the following lemma.

Lemma 3. Let (zi,zihi) ∈ R × R
M for all 1 ≤ i ≤ *T. Then, the* following equality holds in the expectation semiring:

$${\underset{i=1}{\overset{T}{(\sum_{i=1}^{T}z_{i},z_{i}h_{i})}}}=\left(\prod_{i=1}^{T}z_{i}\ ,\ \prod_{i=1}^{T}z_{i}\ \cdot\sum_{j=1}^{T}h_{j}\ \right)$$
hj ) (49)
According to lemma 3, if the local kernels have the form:
ui(yi−1, yi) = (e
⟨θ, f(yi−1,yi,x,i)⟩,

$${\bf e}^{(\theta,\,f(y_{i-1,\,y_{i},\,x,\,i}))}\cdot f(y_{i-1,\,y_{i},\,x,\,i})),$$
$${\mathrm{or}}\ i=1,\cdots,T,{\mathrm{tl}}$$

for i = 1,⋯, T, the global kernel is, according to the Lemma 3

$$\begin{split}\sum_{i=1}^{T}&\mathbf{e}\left(\theta,\,f(y_{i-1,\,y_{i},\mathbf{x},i})\right),\\ &\prod_{i=1}^{T}\mathbf{e}\left(\theta,\,f(y_{i-1,\,y_{i},\mathbf{x},i})\right),\,\sum_{j=1}^{T}f(y_{j-1,\,y_{j},\mathbf{x},j})\right).\end{split}\tag{2}$$
(51)  $\small i)$). 
By applying lemma 2 to the expression (51), we can obtain the partition function (15),

$Z(x;\theta)=\sum_{i=1}^{T}\epsilon^{(\theta,f(y_{i-1,y_{i},x,i}))}$,
$$(52)$$
and its gradient (19):

$$\nabla_{\theta_{m}}Z(\mathbf{x};\theta)=\sum_{\mathbf{y}}\prod_{i=1}^{T}\mathbf{e}\left\langle\theta,f(y_{i-1,y_{i},\mathbf{x},i})\right\rangle\cdot\sum_{j=1}^{T}f(y_{j-1,y_{j},\mathbf{x},j}),\tag{53}$$

as z and h parts of the sum

$$\bigoplus_{i=1}^{T}u_{i}(y_{i-1},y_{i})=\big{(}\ Z(x;\theta),\ \nabla_{\theta}Z(x;\theta)\big{)}.\tag{54}$$

The expression (54) can be computed as the normalization problem (11) by use of the forward algorithm over the expectation semiring. Note that z-parts of addition and multiplication acts as addition and multiplication in the sum-product semiring.

Accordingly, the z-parts of forward vectors will be the same as the forward vectors in the sum-product semiring, and their computation is numerically unstable. In the following subsection we a develop numerically stable forward algorithm which operates over a log-domain expectation semiring. 4.2. Log-domain expectation semiring forward algorithm

$$(47)$$

The log-domain expectation semiring is a combination of the log-domain sum-product semiring and the expectation semiring. It can be obtained if real addition and multiplication in the definition of expectation semiring operations are replaced with their log-domain counterparts.

Before we define the log-domain expectation semiring, we introduce some usefull notation. Firstly, recall that log-domain addition and multiplication are defined with

$a\oplus b=\ln(\mathbf{e}^{a}+\mathbf{e}^{b})$  $a\otimes b=a+b$.  
$$\begin{array}{l}{(55)}\\ {(56)}\end{array}$$
$$(48)$$
The log-product between the scalar z ∈ R and the vector h =
(h[1], . . . , h[M]) ∈ R
M is defined as the vector z ⊗ h:

$$z\otimes h=z\otimes(h[1],\ldots,h[M])=(z\otimes h[1],\ldots,z\otimes h[M]),\tag{57}$$
$$(49)$$
the logarithm of the vector $[h_{1},\ldots,h_{M}]\in\mathbb{R}^{M}$ is defined as 
$$\ln[h_{1},\ldots,h_{M}]=[\ln h_{1},\ldots,\ln h_{M}].$$
$$(50)$$

The vector −∞ is defined as a vector all of whose coordinates are −∞.

6