for each yi ∈ Y, i = 1, . . . T. Finally, the normalization problem can be solved by summation

$$\bigoplus_{y_{0},r}^{T}u_{i}(y_{i-1},y_{i})=\bigoplus_{y_{T}}\alpha r(y r),$$

whose z part is a partition function and the h part is its gradient:

$$\ln Z(\mathbf{x};\mathbf{\theta})=\bigoplus_{y_{T}}\alpha_{T}^{(z)}(y_{T}),\quad\ln\nabla_{\mathbf{\theta}}Z(\mathbf{x};\mathbf{\theta})=\bigoplus_{y_{T}}\alpha_{T}^{(h)}(y_{T}).\tag{78}$$

Hence, the algorithm consists of two parts: i) *forward pass*,
at which the forward vectors are initialized according to (73) and recursively computed by (75)-(76), and during each step the corresponding matrix uiis computed and ii) *termination*,
at which the final summation of the forward algorithm is performed according to (78) and the partition function and its derivatives are obtained.

Figure 2 describes the EMP computation scheme. Recall that the forward-backward based computation requires that all forward and backward vectors be computed and stored until the partition function and the derivatives are obtained in the termination step. When the EMP is used, the computation terminates when the last forward vector is computed by use of the formulas (75) and (76). This can be realized in the fixed memory space with the size independent of the sequence length since the vectors α
(z)
i−1
, α
(h)
i−1 and the matrices ψi should be computed only once in i−1-th iteration and, after having been used for the computation of α
(z)
iand α
(h)
i, they can be deleted. The pseudo code is given in the table Algorithm 2. Here, the computation is performed using only two pairs of vectors (αˆ
(z),αˆ
(h)) and
(α
(z),α
(h)). Note that the coordinates of the h-parts, ˆα
(h)(yi)
and α
(h)(yi), are vectors which carry the information about the gradient and the m-th components of these vectors are denoted with ˆα
(h)
[m](yi) and α
(h)
[m](yi).

In comparison to the FB algorithm which needs the memory size of O(N
2T + M), the EMP has a memory complexity O(N
2 + NM), no longer depending on the sequence length T as in the FB algorithm. The additional cost is paid in time complexity which is increased for the term N
2T M. This is the consequence of the non-sparse computation of the *EMP h* component in line 13. Recall that the FB can be completely sparse implemented and, since A << M in most of the application, the FB time complexity is lower. However, the sparsity can be reduced using the conditionally trained hidden Markov model assumption considered in [29], which we used in our implementation. With the reduced sparsity, the time complexity of the EMP is decreased and it becomes closer to the FB algorithm.

When long sequences are used, the EMP becomes dominating since the FB needs to use the external memory. This assertion is justified in the following section, where we compare the two algorithms on a real data example.

## 5. Experiments

The intrusion detector learning task is to build a predictive model capable of distinguishing between "bad" connections, Algorithm 2: Log-domain EMP algorithm

$$(77)$$

input : x, θ, f (yj−1, yj, x, j); j = 1, . . . , T, yj−1, yj ∈ Y; output: ∇θZ(x; θ)/Z(x; θ) ;
/* Forward algorithm */
1 foreach y0 in Y do
2 α
  **Acknowledgments**  I would like to thank my supervisor, for his kind of support. I would like to thank my supervisor, for his kind of support.  
4 α
* [10] **forreach**$y_{i}$ _in_ $\mathcal{Y}$ **do** * [11] **forreach**$y_{i}$ _in_ $\mathcal{Y}$ **do** * [12] **forreach**$y_{i}$ _in_ $\mathcal{Y}$ **do** * [13] **forreach**$y_{i}$ _in_ $\mathcal{Y}$ **do** * [14] **forreach**$y_{i}$ _in_ $\mathcal{Y}$ **do** * [15] **forreach**$y_{i}$ _in_ $\mathcal{Y}$ **do** * [16] **forreach**$y_{i}$ _in_ $\mathcal{Y}$ **do** * [17] **forreach**$y_{i}$ _in_ $\mathcal{A}(y_{i-1},y_{i})$ **do** * [18] **forreach**$y_{i}$ _in_ $\mathcal{Y}$ **do** * [19] **forreach**$y_{i}$ _in_ $\mathcal{Y}$ **do**
20 α
21 for m ← 1 to M do
(z)(yi) ← αˆ (z)(yi); (h) [m](yi) ← αˆ (h) [m](yi);

22 α
$$/*{\mathrm{~Termination~}}*/$$
* [23] In $Z\leftarrow\bigoplus_{yr}\alpha^{(z)}(y_{T})$ * [24] In $\nabla_{m}Z\leftarrow\bigoplus_{yr}\alpha^{(h)}_{[m]}(y_{T})$ * [25] for $m\leftarrow1$ to $M$ do * [26] $\nabla_{\theta_{m}}Z(x;\theta)/Z(x;\theta)\leftarrow\mathbf{e}^{\ln\nabla_{m}Z-\ln Z}$
called intrusions or attacks, and "good" normal connections.

Conditional random fields have proven to be very effective in detecting intrusion [30].

As we have already mentioned, in the standard CRF training based on the FB algorithm the storage requirements are high when long train sequences are used. This may cause overflows from the internal system memory to disk storage which decreases computational performances, since accessing paged memory data on a typical disk drive is significantly slower than accessing data in RAM [14],[28]. On the other hand, the EMP runs with a small fixed memory and it becomes preferable for long sequences.

In Figure 3 we show the time and memory usage of both al8