# Distributed Graph Coloring: An Approach Based On The Calling Behavior Of Japanese Tree Frogs

H. Hern´andez and C. Blum ALBCOM Research Group Universitat Polit`ecnica de Catalunya, Barcelona, Spain
{hhernandez,cblum}@lsi.upc.edu

## Abstract

Graph coloring—also known as vertex coloring—considers the problem of assigning colors to the nodes of a graph such that adjacent nodes do not share the same color. The optimization version of the problem concerns the minimization of the number of used colors. In this paper we deal with the problem of finding valid colorings **of graphs in a** distributed way, that is, by means of an algorithm that only uses local information for deciding the color of the nodes. Such algorithms prescind from any central control. Due to the fact that quite a few practical applications require to find colorings in a distributed way, the interest in distributed algorithms for graph coloring has been growing during the last decade. As an example consider wireless ad-hoc and sensor **networks, where** tasks such as the assignment of frequencies or the assignment of **TDMA slots are strongly** related to graph coloring.

The algorithm proposed in this paper is inspired by the calling behavior of Japanese tree frogs. Male frogs use their calls to attract females. Interestingly, groups of males that are located nearby each other desynchronize their calls. This is because female frogs are only able to correctly localize the male frogs when their calls are not too close in time. We experimentally show that our algorithm is very competitive with the **current state** of the art, using different sets of problem instances and comparing **to one of the most** competitive algorithms from the literature.

## 1 Introduction

Given an undirected graph G = (V, E), where V is the node set and E **is the edge set, and a** number k > 0 of colors, a valid k-coloring **of the graph is the assignment of exactly one color** to each node such that adjacent nodes (that is, nodes that are **connected by an edge) do not** share the same color. Formally, we say that a k-coloring of an undirected graph G = (**V, E**) is a function c : V → {1, 2, . . . , k} such that c(u) 6= c(v) for each edge (u, v) ∈ E**. The** optimization version of the graph coloring problem (GCP), which is NP**-hard [22], consists**
in finding the minimum number k
∗ **of colors such that a valid** k
∗
**-coloring can be found. This**
number is called the chromatic number of graph G and is denoted by χ(G**). The GCP is**
a quite generic problem. Practical applications originate **especially from problems that can** be modelled by networks and graphs, for example, communication networks. Several tasks in modern wireless ad-hoc networks, such as sensor networks, are related to graph coloring. Examples include TDMA slot assignment [20], detection of mobile objects and reduction of