tree. Next, the master node uses this tree to broadcasts an alert to start running the FrogSim algorithm, that is, the first communication round is triggered. This message also includes the height of the tree which will be used later on by each node to define the amount of information that it must store. The simulation of the FrogSim algorithm is composed of two distinct phases. The first phase (called phase I; see lines 1–5 of Algorithm 1) makes use of the model for the desynchronization of frog calling as introduced by Aihara et al. [1], with only a few modifications. The main difference to other distributed graph **coloring algorithms inspired**
by this model is as follows. The θi **values are used for determining the order in which the**
nodes are allowed to choose colors, whereas in previous algorithms these values were directly associated to specific colors. Note that our algorithm produces a valid coloring already in the first communication round. The second phase (called phase II, see lines 7–15 of Algorithm 1), which is initiated after K > **0 communication rounds of phase I, serves to improve the current** coloring by means of a refinement technique, similar to distributed local search.

Phases I and II of FrogSim will be described in detail in Sections 3.1 and 3.2. Moreover, we will outline how the initially computed tree structure will be used to communicate and store the best coloring found by the algorithm. In this process, each node collects the color identifiers used by its children, determines the highest color used, and sends this information to its parent node. In those cases in which the master node recognizes that the number of colors used in a certain communication round improves over the currently best solution it notifies all the other nodes. This procedure is explained in detail in Section 3.3.

## 3.1 Phase I Of Frogsim

During the first K > 0 communication rounds (where K **is a parameter of the algorithm)** each node i**, when executing its sensor event, executes lines 2–5 of Algorithm 1. First, node**
i will examine its message queue Mi. If Mi **contains more than one message from the same**
sender node, all these messages apart from the last one are deleted. In general, a message m ∈ Mi **sent in this phase has the following format:**

$$\exists m\geq$$

m =< thetam, colorm,relevancem > , (9)
where thetam ∈ [0.1) contains the θ-value of the emitter, colorm **is the color currently used by** the emitter and relevancem **is a parameter that depends on the number of messages received**
by the emitter during the last communication round. This parameter controls the weight that is given by node i to the corresponding message m**. In particular, less weight is given to**
messages that were emitted by nodes that are influenced by many other nodes. The intuition for this definition of the weights is that the θ**-values of nodes that are little influenced by**
other nodes should converge first. This facilitates the convergence of the θ**-values of highlyinfluenced nodes, which in turn facilitates that the system reaches a stable situation, a term**
which refers to a situation in which the θ**-values do not change anymore.**
Based on the messages in Mi, function recalculateTheta() **recalculates a new value for** θi:

$$\theta_{i}:=\theta_{i}+\alpha_{i}\sum_{m\in M_{i}}\mathrm{relevance}_{m}*i n c[\theta_{m}-\theta_{i}]\quad,$$

relevancem ∗ inc[θm − θi] , **(10)**
where αiis a parameter used to control the convergence of the system, initially set to 0.**5. In**
general, the lower the value of αi the smaller the change applied to θi. Moreover, inc[·**] is a**

$$(10)$$
