function—corresponding to the phase shift function of Equation 4—that is defined as follows:

$$i n c[x]={\left\{\begin{array}{l l}{x-0.5}&{{\mathrm{if~}}x\geq0}\\ {x+0.5}&{{\mathrm{if~}}x<0}\end{array}\right.}$$
$$(11)$$

$$(13)$$
x + 0.5 if x < 0**(11)**
Note that this function replaces the sinus function which was originally used in [1] as the phase shift function. This is because we have noticed that this function leads to a better convergence behavior than the sinus function. Next, node i **decides for a possibly new color** in function minimumColorNotUsed(). Formally, the possible color change by node i **can be**
described as:
ci:= min{c ∈ N |6 ∃m ∈ Mi with colorm = c} **(12)**
In words, node i **chooses among the colors that do not appear in any of the received messages**
m ∈ Mi, the one with the lowest identifier. Finally, node i **sends the following message** m
(see function **sendColoringMessage()**):

$$m=<\mathrm{{theta}}_{m}:=\theta_{i},\mathrm{{color}}_{m}:=c_{i},\mathrm{{relevance}}_{m}:=\frac{1}{|M_{i}|^{2}}>$$

Moreover, node i decreases the value of αi (see line 5 of Algorithm 1). Hereby, ρ **is a parameter**
of the algorithm that controls the rate of convergence of the θ**-values. Note that once the**
θ-values have converged the current coloring does not change **anymore. To conclude a sensor**
event, node i deletes all messages from its queue Mi (see function clearMessageQueue()**), that**
is, Mi = ∅.

## 3.2 Phase Ii Of Frogsim

After K > 0 communication rounds, the sensor event of a node i **consists of the execution** of lines 6–15 of Algorithm 1. As mentioned before, this phase **is used for the refinement**
of the current coloring, similar to a distributed local search. Note that in this phase the θ**-values of the nodes are not changed anymore. Within the scope of phase II, each node** i additionally maintains a so-called power parameter pi**. This parameter is initialized in the**
first communication round of phase II with a positive random integer for the nodes i **with**
ci **= 1, and 0 for the rest of the nodes. The values of these power parameters are used to**
resolve conflicts that may arise during the color changes executed in phase II. In particular, in case two neighboring nodes—that is, two nodes that can communicate—have chosen the same color, the one with the higher power value is allowed to keep it. In fact, the usage of such a parameter performs a distributed coloring starting from many nodes at the same time but assuring that it is as good as if the coloring started from **a single node. This node will** be chosen randomly among those nodes which have the lowest θ**-value in each neighborhood.** Further down at the end of this section, a graphic example will illustrate the working of phase II.

A message m sent by function sendRefinementMessage() **(see line 14 of Algorithm 1) has**
the following format:
m =< colorm, powerm > **(14)**
In case the current communication round is not the first communication round of phase II,
node i first examines again its message queue Mi. If Mi **contains more than one message**
from the same sender node, all these messages apart from the last one are deleted. Then, the remaining messages are examined, and a color change only **occurs if there is a message**