
## 3.3 Determining And Storing The Best Coloring Found

It is intuitively clear that the current coloring of our system—that is, the coloring defined by colors cifor all nodes i**—does not only improve over time. In some communication rounds,**
especially during the second phase of the algorithm, the new **coloring after the choice of new**
colors might actually be worse then the coloring of the previous communication round. This behavior is very natural, because the search space of a combinatorial optimization problem is characterized by rather many local minima. If we assume that the current solution corresponds to such a local minimum, the only way to find a better solution is to accept worse solutions for some iterations. In the context of metaheuristic algorithms such an action is known as escaping from a local minimum **[6].**
In order to store the best coloring found by our algorithm over the whole simulation time, the following mechanism is used. Remember that the first action of the algorithm (before simulating phases I and II) consisted in the generation of a virtual minimum spanning tree over the network, resulting in a root node (the master). This **tree is characterized by its height**
h**, which corresponds to the maximum number of communication rounds that a broadcast** message sent by the root node needs in order to reach all nodes **of the network. In this context,**
note that h **may be minimized by using a priori some methods from the literature which are** able to generate spanning trees with minimum diameter in a distributed manner [8].

Each node is required to store its colors from the last 2h **communication rounds. Moreover,**
we assume that each node stores the color it has used in the best-found coloring in a specific variable. The way in which this best-found coloring is determined is as follows. First, at each communication round a node sends the maximum color used by itself and its children (with respect to the tree) to its parent in the tree. Such a message only contains two integers (the maximum color and the communication round identifier). Moreover, no additional messages are required because this information can easily be added to **the messages that are sent anyway** (see lines 4 and 14 of Algorithm 1). Given the height h of the tree, it takes h **communication**
rounds until all the information regarding a specific communication round has reached the root node. Moreover, the number of colors used at this communication round is the maximum color identifier that reaches the root node via one of its children. In case this maximum color is lower than the number of colors used in the currently best-found coloring, the root node broadcasts a message with the corresponding communication **round identifier in which this** coloring was obtained. In order for this information to reach all the nodes of the network, another h **communication rounds are necessary. This is why all nodes must store their colors**
from last 2h **communication rounds. Note that these alert messages from the root node can** also be propagated using the normal messages of Algorithm 1.

## 4 Experimental Results

We coded our algorithm by means of discrete event simulation, implemented from scratch in C++. For the experimental evaluation we chose a large set of different graph topologies: random geometric graphs of different densities, grid graphs of different sizes, and most of the graphs used for the DIMACS challenge [14]. All graphs that we **used for the experimental**
evaluation can be found for download at **http://www.lsi.upc.edu/˜hhernandez/graphcoloring**. Note that an edge connecting two nodes indicates that both nodes are able to communicate directly with each other via their radio antennas.

For the purpose of comparison we re-implemented one of the currently best algorithms