
## 1.1 Our Contribution

In this paper we propose a distributed algorithm for graph coloring based on the calling behavior exhibited by male Japanese tree frogs **for the attraction of females. Several researchers**
have observed that male Japanese tree frogs **decouple their calls [37]. This property has**
evolved because females can only localize the males when their calling is not too close in time. In [1] Aihara et al. proposed a theoretical model for simulating the behavior of these frogs. The authors describe an oscillator system, where each oscillator has a phase θ ∈ [0, 2π] that changes over time with frequency ω (where 2π **is the time interval between two calls of** the same frog). When the phase reaches 2π**, the oscillator fires and returns to the baseline** phase (θ **= 0). The proposed system works such that oscillators try to maximize the distance** between their phases. This model works nicely for the desynchronization of two oscillators.

However, when more than two oscillators are concerned, the model does not accurately reflect the real behavior of the frogs. A subsequent work [2] mentions some potential applications of this model in artificial life and robotics. In both works the author(s) mention the limitations of the systems when operating with groups of more than two coupled oscillators. In fact, already with three oscillators the final solution (and its stability) strongly depends on the initial variable settings.

The desynchronization of the frogs' calls is achieved in a self-organized way. Therefore, the algorithm proposed in this paper, which is based on this self-desynchronization mechanism, can be regarded as a swarm intelligence **approach [7, 5]. Swarm intelligence is a field of**
computer science which is inspired by the collective behavior of social animals and other selforganizing processes from nature. Successful examples from the literature include **particle**
swarm optimization (PSO) [23], which is an algorithm for optimization inspired **by bird**
flocking and fish schooling, and ant colony optimization **(ACO) [11], which is inspired by the**
foraging behavior of ant colonies. One of the distinguishing properties of a swarm intelligence approach is the fact that the problem at hand is solved from a local perspective. Moreover, problem solving is based on the cooperation of rather simple **entities. Instead of each entity** trying to solve the problem by itself, they perform simple tasks from a local perspective. The global problem is solved as a result of cooperation. Therefore, swarm intelligence principles are well suited for their use in distributed algorithms.

The proposed algorithm uses a desynchronization method based on the original model by Aihara et al. [1], with some small modifications. The algorithm can be easily implemented, for example, in sensor networks. In addition to competitive **results it comes with several**
advantages as, for example, a low consumption of energy resources or its potential ability to adapt to changes in the network topology. However, as mentioned before, the main goal of the algorithm is to obtain valid colorings that use an as-low-as-possible number of colors, while keeping the number of iterations necessary to reach these results as low as possible. An extensive experimental evaluation shows that the results of the algorithm are comparable or better than the ones of state-of-the-art algorithms for what concerns the number colors. In particular, the good performance of our algorithm for grid graphs of any size is remarkable. On the downside, the results also show that our algorithm may **require a slightly higher**
number of communication rounds than other state-of-the-art algorithms.