
## 1.2 Prior Work On Graph Coloring

Concerning prior work, a distinction must be made between centralized and distributed algorithms. Concerning centralized algorithms, the literature offers both exact approaches that guarantee to find an optimal solution in bounded time and (meta-)heuristic approaches. A
recent survey can be found in [33]. Due to the intractable nature of the GCP, larger problem instances can only be tackled efficiently by heuristic approaches. Especially effective are the tabu search algorithm from [4], a hybrid approach combining **tabu search and evolutionary** algorithms from [31] and a variable neighborhood search technique [21]. These algorithms are nowadays the best centralized metaheuristics for solving the GCP.

When considering distributed algorithms, it is very difficult (if not impossible) to narrow down the state of the art to a small set of algorithms. This is because distributed algorithms may be designed with very different goals. These goals may concern, for example, the performance for particular topologies, the minimization of execution time (or communication rounds), the generation of the best colorings possible, or the performance for dynamically changing topologies. In addition, a general problem is that **most proposals are not evaluated** on publicly available sets of benchmark instances. Moreover, results are generally not shown per instance, making it difficult to compare to the proposed algorithms. In the following we only focus on algorithms that generate valid solutions and possibly refer to their simplicity, solution quality and time complexity.1**It must also be noted that many of the proposed**
distributed algorithms were developed for applications in **networks of devices with scarce resources. For this reason authors often study the message load the algorithm implies and try**
to minimize the amount of calculus required by the algorithm. Typically, these algorithms are meant to work on a lower layer of the network in parallel with the applications or information flows that the user may require to send. In [15], Fraigniaud et **al. study the effect of the**
amount of information shared between the nodes on the quality of the obtained colorings.

One of the most general works was presented by Finocchi et al. **in [13]. The authors**
introduced three versions of a distributed algorithm and study its behavior under various conditions. The authors considered both the problem of obtaining O**(∆ + 1)-colorings in as** few communication rounds as possible, as well as the problem **of generating the best possible**
colorings without any limit on the number of communication rounds. The authors provide extensive experimental results for both cases. Most of their experimentation is based on random graphs, which are not publicly available. However, they also offer results on a wellknown set of publicly available instances from the DIMACS challenge [14]. As the algorithm proposed in [13] was shown to outperform the state of the art, **we have chosen this algorithm** for comparison.

Concerning distributed algorithms based on swarm intelligence principles, the literature offers, for example, a method inspired by the synchronous flashing of fireflies (see [27]). This algorithm, which allows a simple implementation, reaches valid colorings fast, in a constant number of communication rounds, regardless of the size of the network. However, this work does not focus on minimizing the number of colors. The first intent to use the calling behavior of frogs for graph coloring was presented in [29]. Valid colorings are obtained by assigning a color to each phase used by the nodes (that is, the oscillators). Therefore, if two nodes are synchronized to exactly the same phase, they will be sharing **a common color (the authors**
consider a function f : [0, 2π] → (R, G, B), where 2π **is the time frame between two callings**
1 In the scope of this paper the time complexity is, as usual, measured in terms of **communication rounds**.

A communication round is the unit of time in which each node is **allowed to send at most one message.**