Our model will now be explained according to this structure. Once the joint decomposition, which consists in the *P(All Variables)*, is settled, one can ask questions to the Bayesian program that will be computed with the joint:

$P(\text{\it Searched}\,|\,\text{\it Known})=\frac{\sum_{\text{\it Free}}P(\text{\it Searched}\wedge\text{\it Free}\wedge\text{\it Known})}{P(\text{\it Known})}$
€
€
€
€
€
which can be simplified by normalizing P(Searched |Known) = 1Z*JointDistribution*

$$\phi$$:) $$u o w n)=\frac{1}{Z}\sum_{F r e e}J o i n t D i s t r i b$$

## Description Of The Model Variables

A very simple set of variables is as follows. We have the n characters as possible targets; each of them several bound variables. Health/Hit points (HP) are discretized in 10 levels, from the lower to the higher. Distance (D) is discretized in 4 zones around the robot character: contact where it can attack with a contact weapon and then 3 distances, the further one being "out of range even for the longest distance weapon/spell". Ally (A) is a Boolean variable mentioning if character i is allied with the robot character. Delta hit points (ΔHP) is a 3-valued interpolated value from the previous few seconds of fight that informs about the ith character getting wounded or healed (or nothing). Imminent death (ID) is also an interpolated value that encodes HP, delta HP and incoming attacks/attackers. This is a Boolean variable saying if the ith character if going to die anytime soon. This is an example of what we consider that an experienced human player will infer automatically from the screen and notifications. Class (C), simplified over 4 values, gives the type of the ith character: a Tank can take a lot of damages and taunt enemies, a Contact damager can deal huge amounts of damage with contact weapons (rogue, barbarian…), Ranged stands for the class that deals damages from far away (hunters, mages…) and Healers are classes that can heal (in considerable amounts). The Resist variable is the combination of binary variables of resistance to certain types of (magical) damages into one variable. 

With 3 possible resistances we get 23=8 possible values. For instance "*Ri=FireNat*" 
means that the ith character resists fire and nature-based damages. Armor (physical damages) could have been included, and the variables could have been separated. The possible values of the skill variable are all the possible skills for the given character, and not only the available ones to cast at the moment to be able to have reusable probability tables (i.e. learnable tables).

Target: 
T ∈{t1…tn }
Hit points: 
HP1…HPn | HPi ∈[0…9]
Distance: 
D1…Dn | Di ∈{*Contact,Close*,Far,*VeryFar*}
Ally: 
A1…An | Ai ∈{ *false,true*}
Derivative hit points: 
€
ΔHP1…ΔHPn | ΔHPi ∈{−,,+}
Imminent death: 
€
ID1…IDn | IDi ∈{ *false,true*}
Class: 
€
C1…Cn |Ci ∈{*Tank,Contact,Ranged,Healer*}
Resists: 
€
R1…Rn | Ri ∈{Nothing,Fire,Ice,Nature,FireIce,IceNat,FireNat,All}
€