# Reinforcement Learning In Partially Observable Markov Decision Processes Using Hybrid Probabilistic Logic Programs

Emad Saad Department of Computer Science Gulf University for Science and Technology Mishref, Kuwait saad.e@gust.edu.kw Abstract—**We present a probabilistic logic programming**
framework to reinforcement learning, by integrating reinforcement learning, in POMDP environments, with normal hybrid probabilistic logic programs with probabilistic answer set semantics, that is capable of representing domain-specific knowledge. 

We formally prove the correctness of our approach. We show that the complexity of finding a policy for a reinforcement learning problem in our approach is NP-complete. In addition, we show that any reinforcement learning problem can be encoded as a classical logic program with answer set semantics. We also show that a reinforcement learning problem can be encoded as a SAT problem. We present a new high level action description language that allows the factored representation of POMDP. Moreover, we modify the original model of POMDP so that it be able to distinguish between knowledge producing actions and actions that change the environment.

## I. Introduction

Reinforcement learning is the problem of learning to act by trial and error interaction in dynamic environments. Reinforcement learning problems can be represented as Markov Decision Processes (MDP), under the assumption that accurate and complete model of the environment is known. This assumption requires the agent to have perfect sensing and observation abilities.

However, complete and perfect observability is unrealistic for many real-world reinforcement learning applications, although necessary for learning optimal policies in MDP 
environments. Therefore, different model is needed to represent and solve reinforcement learning problems with partial observability. This model is Partially Observable Markov Decision Processes (POMDP). Similar to MDP, POMDP requires the model of the environment to be known, however states of the world are not completely known. Consequently, the agent performs actions to make observations about the states of the worlds. These observations can be noisy due to imperfect agent's sensors. Similar to MDP, dynamic programming methods, by value iteration, has been used to learn the optimal policy for a reinforcement learning problem in POMDP environment.

A logical framework to reinforcement learning in MDP 
environment has been developed in [30], which relies on techniques from probabilistic reasoning and knowledge representation by normal hybrid probabilistic logic programs [34]. The normal hybrid probabilistic logic programs framework of [30] has been proposed upon observing that dynamic programming methods to reinforcement learning in general and value iteration in particular are incapable of exploiting domainspecific knowledge of the reinforcement learning problem domains to improve the efficiency of finding the optimal policy. 

In addition, these dynamic programming methods use primitive representation of states and actions as this representation does not capture the relationship between states [22] and makes it difficult to represent domain-specific knowledge. However, using richer knowledge representation frameworks for MDP and POMDP allow efficiently finding optimal policies in more complex stochastic domains and lead to develop methods to find optimal policies with larger domains sizes [22].

The choice of normal hybrid probabilistic logic programs 
(NHPLP) to solve reinforcement learning problems in MDP 
environment is based on that; NHPLP is nonmonotonic, therefore more suitable for knowledge representation and reasoning under uncertainty; NHPLP subsumes classical normal logic programs with classical answer set semantics [7], a rich knowl-edge representation and reasoning framework, and inherits its knowledge representation and reasoning capabilities including the ability to represent and reason about domain-specific knowledge; NHPLP has been shown applicable to a variety of fundamental probabilistic reasoning problems including probabilistic planning [28], contingent probabilistic planning [31], the most probable explanation in belief networks, the most likely trajectory in probabilistic planning, and Bayesian reasoning [29].

In this view, we integrate reinforcement learning in POMDP 
environment with NHPLP, providing a logical framework that overcomes the representational limitations of dynamic programming method to reinforcement learning in POMDP and is capable of representing its domain-specific knowledge. In addition, the proposed framework extends the logical framework of reinforcement learning in MDP of [30] with partial observability. We show that any reinforcement learning problem in POMDP environment can be encoded as a SAT