
## 5. An Application Scenario

In a general form an application scenario within our approach can be described as a sequence of the following steps.

1. Define a set of features considered by domain experts as the most important ones for the classification. For example, a domain expert can assume the velocities of aircraft in coordinates X and Y as the most important features for predicting the STCA.

2. Within a defined set of features, collect a representative set of data samples confidently classified by domain experts. For instance, a domain expert can arrange a set of radar data received from different pairs of aircraft in which some of the radar cycles were labeled as the STCA.

3. Analyze a *priori* knowledge and formulate priors within the Bayesian methodology. For example, domain experts can represent their knowledge in a form of decision tree asking specific questions. Such a *priori* information can be used within our approach in order to improve the performance.

4. Define parameters of DTs such as the minimal number of data samples, pmin, allowed to be in splitting nodes. By changing this parameter, a modeler can find in an *ad hoc* manner the number of splitting nodes providing the best performance of DTs.

5. Define parameters of MCMC such as the number of burn-in and post burn-in samples, proposal probabilities for the death, birth, change-split and changerule, as well as the sampling rate. At this step a modeler can also specify suitable proposal distributions for the moves. However, if a modeler has no idea about the proposal distribution, a uniform distribution, known also as an 
"uninformative" prior, is used.

6. Specify a criterion for convergence of Markov Chain. Within the Bayesian MCMC technique, the convergence of a Markov Chain is usually achieved if the number of burn-in samples set enough large. Practically, the convergence is achieved if after approximately 1/3 of burn-in samples the likelihood values do not change significantly. This can be easily visualized by observing the log likelihood values plotted versus the number of post burn-in samples.

7. A modeler has to control the diversity of DTs collected during the post burn-in phase. The diversity is estimated implicitly by estimating an acceptance level which is the ratio of the number of the proposed and accepted DTs to the total number of proposed DTs. Practically, when the acceptance level is near 0.25, a set of collected DTs is optimally diversified.

8. Practically, the desired acceptance level is achieved by changing the following parameters: pmin, the variance of proposal distribution, and the expected number of splitting nodes.

9. To select a single DT providing the most confident classification, a modeler has to predefine a level of confident classification, 0. The value of 0 is dependent on the cost of misclassifications allowed in an application. Clearly, if the cost of classification is high, the value of 0 is defined close to 1.0, say 0.9990. This means that a decision is confident if no more than 10 classifiers from 10000 are contradictory. Otherwise, a decision is assigned uncertain.

10. Having obtained a confident DT, a modeler can observe a decision model and analyze the features used in this model. Additionally, a modeler can run the 