In practice, the number of DTs in the ensemble as well as the number of the training examples can be large. Nevertheless, counting the number of confident and correct outcomes as described above, we can find a desired DT which can be used for interpreting the confident classification. The performance of such a DT can be slightly worse than that of the Bayesian DT ensemble. Within the Chapter we provide the experimental comparison of their performances. The main steps of the selection procedure are next.

All that we need is to find a set of DTs which cover the maximal number of the training samples classified as confident and correct while the number of misclassifications on the remaining examples is kept minimal. To find such a DT set, we can remove the conflicting examples from the training data and then select the DTs with a maximal cover of the training samples classified by the DT ensemble as confident and correct. 

Thus the main steps of the selection procedure are as follows:
1. Amongst a given Bayesian DT ensemble find a set of DTs, S1, which cover a maximal number of the training samples classified as confident and correct with a given confidence level 0.

2. Find the training samples which were misclassified by the Bayesian DT 
ensemble and then remove them from the training data. Denote the remaining training samples as D1. 

3. Amongst the set S1 of DTs find those which provide a minimal misclassification rate on the data D1. Denote the found set of such DTs as S2. 

4. Amongst the set S2 of DTs select those whose size is minimal. Denote a set of such DTs as S3. The set S3 contains the desired DTs. 

The above procedure finds one or more DTs and puts them in the set S3. These DTs cover a maximal number of the training samples classified as confident and correct with a given confident level 0. The size of these DTs is minimal and any of them can be finally selected for interpreting the confident classification. 

## 4. Experimental Results

In this Section first we describe the data used in our experiments. Then we show how the suggested Bayesian technique runs on these data. The resultant Bayesian averaging over DT models gives us a feature importance diagram. The suggested selection procedure gives us the single DTs for each run and finally we compare the predictive accuracies obtained with the existing procedures.

## 4.1. The Experimental Data

The data used in our experiments are related to the Short-Term Conflict Alert (STCA) problem which emerges when the distance between two aircraft, landing or taking off, might be critically short. Table 1 lists 12 features selected for predicting STCA. 