some propositional or causal atoms, we must "complete" each propositional or causal atom concerned as follows:
true(alpha) v -true(alpha). or cause(alpha,beta) v -cause(alpha,beta). This is generally not necessary, and should be avoided as far as possible since it is computationally demanding.

The interesting result consists in the explanation predicates:
ecSet(alpha,beta,{alpha,delta,gamma}) **represents the explanation atom**
α expl β bec *poss* {**α, δ, γ**}.

Here come the first rules:
ontt(I,J) :- ont(I,J). ontt(I,K) :- ontt(I,J), ont(J,K). (cf 2b §**2.2).**
For the sake of "safety" of some rules, and for defining impCO **introduced**
below we may need to define all the symbols, and the ones which can appear in an explanation set (suffix "E"). symbolE(X) :- cause(X,Y). symbolE(Y) :- cause(X,Y). symbolE(X) :- ont(X,Y). symbolE(Y) :- ont(X,Y). symbol(X) :- symbolE(X).

Implication derived from causal and ontological atoms ("s" for "strict"):
impCO(I,J) :- cause(I,J). impCO(I,J) :- ont(I,J).

impCO(I,K) :- impCO(I,J), impCO(J,K). impCO(I,I) :- symbolE(I).

impCOs(I,J) :- impCO(I,J), not impCO(J,I).

We split the general basic generation rule 3a §**2.2, in order to improve the**
computational performances. Indeed, in the first three particular cases, only one optimal initial explanation atom in (I,J) **exists, thus the computation can**
be simplified.

ecinit(I,J,E) **represents** I expl J bec *poss* {I, E} **where this explanation**
atom is obtained without using the transitivity rule:
ecinit(I,J,I) :- cause(I,J). ecinit(I,J,I) :- cause(I,X), ontt(J,X), impCO(I,J).

ecinit(I,J,I) :- cause(I,X), ontt(X,J). ecinit(I,J,I) :- cause(I,X), ontt(E,X), ontt(E,J), impCO(I,E).

The most complicated case (with the two ontological axioms) may lead to several explanation atoms from I to J**, which requires some complications:** ecinit3p(I,J,E) :- ecinit(I,E,E), cause(I,X), ontt(E,X), ontt(E,J), not ecinit(I,J,I),
not ecinit(I,J,J).

nonecinit(I,J,E) :- ecinit3p(I,J,E1), ecinit3p(I,J,E), impCOs(E,E1).

ecinit(I,J,E) :- ecinit3p(I,J,E), not nonecinit(I,J,E).

[Avoids keeping clearly non optimal ones.]
Since the set of conditions are singletons or pairs in the initial explanation atoms [ecinit**], set representation was not required. Real explanation atoms**