[ecSet**] are introduced now, together with explicit sets which allow a serious** simplification of the ASP rules.

Firstly, we initialize ecSet **with** ecinit [\#insert(Set1,E,Set) means in DLVComplex: Set = Set1 ∪ {E}]:
ecSet(I,J,{I}) :- ecinit(I,J,I). ecSet(I,J,{I,J}) :- ecinit(I,J,J), not ecSet(I,J,{I}). ecSet(I,J,{I,E}) :- ecinit(I,J,E), not ecSet(I,J,{I}), not ecSet(I,J,{I,J}).

Then comes the translation of Point 3b §**2.2.**
ecSet(I,J,Set) :- ecSet(I,K,Set1), not ecSet(I,J,Set1), ecinit(K,J,E2), E2 != K,
\#insert(Set1,E2,Set).

ecSet(I,J,Set) :- ecSet(I,K,Set), ecinit(K,J,K).

[Nothing to add in this case, since we know that Set ⊢C K.]
And this is enough for getting all the relevant explanation atoms. Only a few computational optimization tricks complicate a little bit the writing, however, the ASP rules remain very close to the formal rules given in §**2.2.**

## 3.3 Optimizing The Explanation Atoms

This is the most computationally demanding part. Rigorously, it is not mandatory. However, it is important in order to avoid providing too many unnecessary explanation atoms which complicate the interpretation of the result.

As a short example, suppose we have following data:
α causes β, α causes β0, β2 causes γ, β1 **causes γ**,
β2 →IS−A β0, β1 →IS−A β, β2 →IS−A β1.

Then, we get the following explanation atoms concerning (**α, γ**):
Expl1: α expl γ bec *poss* {α, β1} **and Expl2:** α expl γ bec *poss* {**α, β**2}.

Since we have β2 →IS−A β1, we get β2 → β1 from 2a §2.2 in W**, even if**
the user does not provide any explicit W. Thus, each element in {**α, β**1} is entailed by some element in {α, β2} **and not conversely. Thus, the weaker** set {α, β1} **is more likely to be satisfied, whatever are the other data, and in**
particular whatever may be an explicit W **given as additional data. Thus, it**
is useless, and disturbing, to provide Expl2: Expl1 is enough. It happens here that Expl1 is *optimal* **with the given data. Obviously, in more complex cases** involving disjunction, the "element wise" test would not be enough to **discard** all the sets of conditions which are too strong for entailment. However, the