test described here is a good compromise between efficient computation and readability of the result.

We have tried various other programs providing only the [quasi] optimal sets, in order to avoid this "optimizing" part. All of them were much slower: it is better to provide first the explanation atoms with a program such as the one given in §**3.2, which does not take great care for avoiding superfluous** answers, and then to prune the set of solutions.

Here comes the "optimizing part". Remind that not all the simplifications or optimizations possible are made. As explained above, only those which are easy to compute are made. Indeed, except in artificially complicated data, most of the simplifications are made in this way, while dealing with the tricky cases would make the program too slow for a marginal **advantage. These simplification/optimizations are mandatory in order to facilitate**
human reading, and could be omitted in a purely formal perspective since anyway the produced explanation atoms cover all the possible situations. The rules are very simple:
imp(I,J) :- impCO(I,J). **(additional predicate** imp **useless in the version**
presented here).

Propagating the truth values:
true(J) :- true(I), imp(I,J). -true(I) :- -true(J), imp(I,J).

Eliminating sets of conditions which contain another set
[\#subSet(Set1,Set) means Set1 ⊆ Set and \#member(E,Set) means E ∈ Set]:
toolargeSet(I,J,Set) :- ecSet(I,J,Set1), ecSet(I,J,Set), Set1 != Set,
\#subSet(Set1,Set).

ecSetsmall(I,J,Set) :- ecSet(I,J,Set), not toolargeSet(I,J,Set).

impCOSetEl(Set1,E2) :- ecSetsmall(I,J,Set1), ecSetsmall(I,J,Set2),
Set1 != Set2, impCO(E1,E2), \#member(E1,Set1), \#member(E2,Set2), not \#member(E1,Set2), not \#member(E2,Set1).

nonImpCOSet(Set1,Set2) :- ecSetsmall(I,J,Set1), ecSetsmall(I,J,Set2),
Set1 != Set2, symbolE(E2), \#member(E2,Set2),not \#member(E2,Set1), not impCOSetEl(Set1,E2). **% ( "**not \#member(E2,Set1),**" is optional)**
toostrongSet(I,J,Set) :- ecSetsmall(I,J,Set), ecSetsmall(I,J,Set1),
Set != Set1, nonImpCOSet(Set1,Set), not nonImpCOSet(Set,Set1).

ecSetRes(I,J,Set) :- ecSetsmall(I,J,Set), not toostrongSet(I,J,Set).

As a result, we only keep the explanation atoms ecSetRes(I,J,Set) **where**
no element can be removed from Set **and where no set** StrongSet **is such that** ecSet(I,J,StrongSet) **and each element of** Set **is implied (in the meaning of**
impCO**) by some element of** StrongSet**, and not conversely.**