This program is rather slow: the two programs (§**3.2 and the present 3.3)**
can be launched together for examples such as in the diagram of §**2.3 and for** slightly larger example, but it is impossible for our "big example". However, it is possible to launch the first program (instantaneous on our examples), and then the second one starting with the results of the first one. **Then, our** "big example" is solved in far less than one minute on our computer.

## 3.4 Checking The Set Of Conditions

Finally, the following program starts from the result of the preceding programs and checks, in each answer set, whether the set of conditions is satisfied or not. This program could also be launched starting from the result **of the** first program (replacing ecSetRes **with** ecSet**), simply superfluous explanation** atoms would be checked also, and almost no "optimization" would be done.

The result is given by explVer(I,J,Set): I expl J bec *poss* Set where Set is satisfiable in the answer set considered ("Ver**" stands for "verified").** explSuppr(I,J,Set) :- ecSetRes(I,J,Set), -true(E), \#member(E,Set).

explVer(I,J,Set) :- ecSetRes(I,J,Set), not explSuppr(I,J,Set).

Notice that only "individual" checking is made here, in accordance with the requirement that the computational properties remain manageable. In each answer set, this check is enough.

Notice that, as already evoked, in our running split program (not provided in full here for lack of space), all the answer sets are put into a single one, with an index parameter added for each old answer set. This allows to **make** real cautious reasoning when checking the consistency of the explanation sets (and only for this point), in accordance with the formalism. Then, a few more rules could be added in order to get results in full accordance with our formalism (since e.g. answer sets do not provide all the classical models).

However, even if these rules are written with care, it seems unlikely that the resulting program can run in practice for great examples. As already evoked above, if we want to get all the classical models, a possibility is to require the *completion* **of all the atoms (propositional or causal) which can provoke** the existence of various answer sets, by adding the disjunctive rules true(alpha) v -true(alpha). and cause(gamma,delta) v -cause(gamma,delta).

for each of these atoms involved in a non atomic formula. This solution is easy to write in the program, but becomes clearly unmanageable from a computational point of view since the number of answer sets may explode. It is the standard, but not practical, way for getting all the classical models