heard some while like **means** *like all***. The ontological information would**
be provided by the user as follows: loud **bell** →IS−A(object) bell and white car →IS−A(object) car.

This would provide the following →IS−A **relation between atoms**
heard(bell) →IS−A heard(loud bell). and like(car) →IS−A like(white car)..

This means that the ASP formulation would contain the following facts and rules: ont object(loud bell,bell). ont object(white car,car).

ont([P,X],[P,Y]) :- onekind(P), ont object(X,Y). and ont([P,Y],[P,X]) :- allkind(P), ont object(X,Y).

Dealing with lists (denoted inside brackets) of DLV-Complex is convenient: a small set of ASP rules can deal with predicates of any arity, **even if**
we do not describe the full formalism here for the sake of conciseness.

Propositional parameters would be dealt with the following rule:
ont([A],[B]) :- ont object(A,B), propkind(A), propkind(B).

Let us consider a binary predicate own, with own(student, book**) meaning**
that the individual (or object) student **(whatever it denotes in our formalism)** owns the object called book. Here, own(X, Y **) is intended to mean: "***all X*
own some Y**". The following rule** (O-O) **can deal with this predicate:**
ont([P,X,Y],[P,X1,Y1]) :- all onekind(P), ont object(X1,X), ont object(Y,Y1).

The user should state the kind of parameters for each predicate, **as follows:**
onekind(heard). allkind(like). all onekind(own). propkind(alpha).

(A more extensive use of the list notation would allow to write rules dealing with any arity in a yet more natural way.)
Writing onekind(heard) **means that the classes or objects which can appear**
as parameters of the unary predicate heard **of the formal system have adapted** meaning. In this example, bell **may denote the class of some bells considered** in the situation at hand, loud bell **the class of those bells which are loud** and some bell could denote a precise loud bell**. Notice that the objects are** intended to denote either individuals or classes of individuals.

In this situation the user could add the following atom to the one given above about bells: ont object(some bell,loud bell).

As an example, let us consider our binary predicate own**, with the known**
informations provided by the user as follows in ASP:
ont object(tom,student). ont object(book,document).