Then, the following ontological atoms would be deduced by the system
(again in ASP notation): ont([own,tom,book], [own,tom,document]) ont([own,student,book], [own,tom,book]) ont([own,student,book], [own,tom,document]).

A predicate for which no "all/one" information is given could be used, but it would never give rise to ontological atoms.

This kind of formulation is in accordance with our requirements for the formalism: allowing serious expressiveness while keeping computation **manageable. To this respect, for large examples it can be useful to reduce the**
instantiation size by restricting the parameters which can be used for some predicates, by adding not unrestr(P), kindPar(P,X,Y) **to the body of the rule**
(O-O)**. Rules such as the following ones should be added**
unrestr(P) :- not restr(P), pred(P). pred(P) :- onekind(P). **, [...**allkind(P)**,...].** The user would provide the relevant information about restr and kindPar.

## 3.6 Conclusion And Future Work

We have shown how a recent version of running ASP systems allow easy translation of logical formalisms. The example given here is a formalism allowing to infer "explanations" from "causal and ontological" information, with two requirements: 1 It must be easy and natural to formalize a **given** situation. 2 Computation should remain as manageable as possible.

These requirements justify some restrictions of our formalism, in particular the fact that we accept only classical atoms inside the causal and ontological atoms, without operators such as negation or disjunction. The formalism is not restricted to the propositional case, and, as explained in the last subsection, it involves an ontology slightly more general that the rudimentary one developed in the full ASP description given in the preceding subsections.

From the perspective of existing (and predictable in a near future) ASP
systems, here are some conclusions that can be drawn:
The existing recent extensions of ASP systems are a real bonus. It is much easier to *write* **the program now than it was a few years ago. More importantly perhaps, the difference is even greater when** *reading* **such a program.**
Indeed the claimed assertions about ASP, namely that it makes programs easy to write and to read, are true only when such extensions are used. Oth-