more importantly reading (thus modifying easily) programs in ASP for a given problem. Indeed, ASP is presented as (and is) a declarative formalism where it should be immediate to write a program from a logical formalization of a given problem. In practice, this is rarely as easy as claimed. We choose as an example a formalism that we have designed in collaboration with Philippe Besnard and Marie-Odile Cordier. This formalism aims at a logical formalization of explanations from causal and "is-a" statements. Given some information such as "fire causes smoke" and "grey smoke is a smoke", if "grey smoke" is established, we want to infer that "fire" is a (tentative)
explanation for this fact. The formalization [3, 4] is expressed in terms of rules **such as**
"if α causes β and δ isa β, then α explains δ because {α, δ} **is possible**".

Here, α, ... **may be first order atoms (without function symbols). Thus,**
we can express these rules in a "Datalog" formulation. When various **explanations are possible, some of them can be subsumed by other ones, and**
the set of the solutions should be pruned. This concerns looking for **paths**
in some graph and ASP is good for these tasks. There currently exist systems which are rather efficient, such as DLV1**[9] or gringo/clasp or claspD**2.

Transforming formal rules into an ASP program is easy. ASP should then be an interesting tool for researchers when designing a new theoretical formalization as the one examined here. An ASP program should help examining a great number of middle sized examples, and check whether the results are in accordance with our expectations. Then if middle sized examples could work, a few more optimization techniques could make real sized examples work. Since ASP rules are close to a natural language, a final user could easily adapt a general framework to his precise needs, without requiring a complex specific system.

Even if ASP allows such direct and efficient translation, a few problems complicate the task.

Firstly, the poor data types available in pure ASP systems is a real drawback. Our rules involve sets. There are many ways to represent sets in existing ASP systems. We had designed programs working in this way [11] (for systems not allowing functional terms), by representing a set as follows:
Expl(I, J, N, E) meaning there exists an "explanation" from I to J **with a** set of conditions which is the set {E/Expl(I, J, N, E)}, where N **is an index,**