necessary when M sets of conditions exist (N ∈ {1, · · · , M}**). However, the** program is rather hard to read, and thus to be adapted. Part of this difficulty comes from the second drawback given now.

Secondly, in pure ASP, it is hard to reuse part of a program. Similar rules should be written again, in a slightly different way. Thus, e.g. the rules necessary to deal with sets should be rewritten in many parts **of the** full program.

Thirdly, there are restrictions concerning "brave" or "cautious" **reasoning.**
In ASP, "the problem is the program" and the solution consists in one or several sets of atoms satisfying the problem. Each such set is an *answer* set**. These answer sets are the "ASP models".** *Brave* **(respectively** *cautious*)
solutions mean to look for atoms true in some answer set (respectively all the answer sets). In the existing ASP systems, this is generally possible, but in a restricted way only.

All these difficulties make that in practice, the claimed advantage in favour of the use of ASP is not so clear when the final program is written. The rules in the program are encumbered by various tricks necessary to overcome these limitations, and any subsequent modification in the program becomes complex.

However, things are evolving. To take the example of DLV, points 1 and 2 above are partly solved: DLV-Complex3 **deals with the data structure**
problem, since it admits sets and lists. DLT 4 **allows the use of "templates",**
which solves to a great extent the problem for reusing part of a program. It is not yet possible to use these two improvements together. Since here the most problematic case was due to the use of sets, we have used **DLVComplex, without DLT. When DLT will be able to work with DLV-Complex,**
the task will be yet easier.

In the next section, we present what should be known about our explanation formalism in order to understand its ASP translation. Then, in section 3, we describe its ASP translation, explaining the interest, and the drawback, of using ASP for this kind of job. Finally, we conclude by a few reasonable expectations about the future ASP systems which could help a final **user, and** make ASP a really interesting programming paradigm for such problems.

3**http://www.mat.unical.it/dlv-complex**
4**https://www.mat.unical.it/ianni/wiki/dlt**