
| Parsing and interpreting ursa statements ↓                                                                       |
|------------------------------------------------------------------------------------------------------------------|
| Generating a goal formula from the constraint ↓ Transforming the goal formula to cnf ↓ Invoking the sat solver ↓ |
| Turning sat models into values of the independent variables                                                      |

Theorem 5.2. If the variables v1, v2, . . ., vn **are (the only) unknowns in an** ursa specification S; assert(b);, then it leads to a solution (v1, v2, . . . , vn) = (c1, c2, . . . , cn), (i.e. this solution leads to the model of the formula s(b)) iff hv1 = c1; v2 = c2; . . . ; vn = cn; S; assert(b), s∅i 7→ hskip, si where s(b) is **true**.

The above semantics also ensure faithfulness **of problem specifications - each model**
meeting the specification leads to one model of the generated **propositional formula, and each**
model of the generated propositional formula leads to one model of the input specification. This property is essential for constructing (or counting) all solutions of a problem.

## 6. Interpreter For Ursa Language

In this section we describe the implementation of the interpreter for the ursa **language.**5 The interpreter is implemented in the programming language **C++. The whole system**
has a simple architecture and is relatively small (around 100Kb of source code, not counting sat **solver used). The overall architecture of the system is illustrated in Figure 1.**
6.1. **Parsing and Interpreting** ursa Statements. **Statements can be entered in an**
interactive mode and processed one by one or provided to the ursa **system within a file.** Statements are interpreted according to the semantics described in Section 5.

The table of symbols (i.e., the store**) stores values of numerical and Boolean variables.**
Numerical variables are represented by a class (Number) whose objects can be either symbolic numbers (i.e., vectors of propositional formulae) or **concrete numbers. For this class all**
standard arithmetic (except division6**), bitwise logical, and relational operators are defined.**
In principle, these operators return ground values for ground operands and vectors of formulae for symbolic operands (but, if possible, return ground values for symbolic operands).

Boolean variables are represented by analogy (by the class Boolean).