Symbolic values of variables are represented by vectors of propositional formulae. There are classes for dealing with propositional formulae (Formula**) and vectors of propositional** formulae (FormulaVector**). The length of vectors of propositional formulae representing**
numerical variables is given as a parameter to the interpreter (the default value is 8, corresponding to integers from 0 to 255).

In the current implementation, all numerical variables and **constants are treated as**
unsigned integers (represented by binary representation). For the class FormulaVector all standard arithmetic (except division), bitwise logical, and relational operators are defined. They deal only with symbolic numerical and Boolean values (in contrast to the class Number and Boolean). The implementations of bitwise logical operators are simple and straightforward. The implementations of the arithmetic operators modulo 2n **and the relational**
operators are more complex because resulting bits depend on **all the previous bits of the** operands. Figure 2 shows the implementation of the relational operator > **(it processes**
propositional formulae corresponding to bits from the least significant one and returns a unary vector). Note that the given function is not computing a value for the relational operator > for concrete numbers, but it sets a formula that corresponds to > **for two symbolic**
input numerical expressions.

FormulaVector1 FormulaVector::operator > (const FormulaVector &fv) {
FormulaVector1 result, r1,r2; r1 = (*this)[size-1];
r2 = fv[size-1];
result = (r1 & ~r2); for(int i=size-2;i>=0;i--) {
r1 = (*this)[i];
r2 = fv[i]; result = (r1 & ~r2) | (result & (r1==r2));
}
return result;
}
Figure 2: Implementation of the operator >.

For the sake of efficiency (both time and space), the technique **of shared expressions**
was used. So, each subformula is stored only once, but there can be more references to it
(from different formulae). All formulae generated during the **interpretation of the program** are stored by the class FormulaFactory **in this way. Hence, the formulae are not stored**
individually, but in a form of a directed graph that stores links between them. Each formula that is not a propositional variable is represented by its connective and by references to its subformulae. Each formula is assigned a unique (numerical) **identifier.**
Example 6.1. Figure 3 illustrates how the (artificial) formula (p ∧ (q ∧ r)) ∨ ((q ∧ r) ∧ ¬p)
and its subformulae are stored internally.

6.2. Generating a Goal Formula from the Constraint. **When executing the command**
assert**, the interpreter invokes the underlying solving process. For the given constraint**
(given as an argument to assert**), a corresponding (single) propositional formula is generated, transformed to** cnf **and, by a** sat **solver, it is checked whether the formula is true**
in some valuation. If yes, then the system lists values of all independent variables in that