only if the position (i, j**) is occupied by a queen. It has to be ensured that in each row there** is exactly one queen and it has to be ensured that in each column there is at least one queen (this is sufficient if the former condition is satisfied). No-attack conditions are expressed in a straightforward manner. A corresponding ursa **specification is as follows (the numerical** values could be represented by any vector length that can accommodate nDim):
/* ***** queens-3 ***** */
nDim = 8; bHorizontal = true; for(ni=0; ni<nDim; ni++) {
bOne = false; bMoreThanOne = false; for(nj=0; nj<nDim; nj++) {
bMoreThanOne ||= bOne && b[ni][nj];
bOne ||= b[ni][nj];
} bHorizontal &&= bOne && !bMoreThanOne;
}
bVertical = true; for(ni=0; ni<nDim; ni++) {
bOne = false; for(nj=0; nj<nDim; nj++)
bOne ||= b[nj][ni];
bVertical &&= bOne;
}
bDiagonal = true; for(nAi=0; nAi<nDim-1; nAi++)
for(nAj=0; nAj<nDim; nAj++)
for(nBi=nAi+1; nBi<nDim; nBi++)
for(nBj=0; nBj<nDim; nBj++)
if (nBi-nAi==nBj-nAj || nBi-nAi==nAj-nBj)
bDiagonal &&= (!b[nAi][nAj] || !b[nBi][nBj]);
assert_all(bHorizontal && bVertical && bDiagonal);
It seems that the four-fold loop in the above specification can be a source of inefficiency.

Indeed, instead of going through all possible values for nBi **and only then checking if the** corresponding positions should be tested for attack condition, one can calculate and consider only relevant coordinates nBj**, as in the following modified specification:**
/* ***** queens-4 ***** */ nDim = 8; bHorizontal = true; for(nx=0; nx<nDim; nx++) {
bOne = false; bMoreThanOne = false; for(ny=0; ny<nDim; ny++) {
bMoreThanOne ||= bOne && b[nx][ny];
bOne ||= b[nx][ny];
}
bHorizontal &&= bOne && !bMoreThanOne;
}