bVertical = true; for(ny=0; ny<nDim; ny++) {
bOne = false; for(nx=0; nx<nDim; nx++)
bOne ||= b[nx][ny];
bVertical &&= bOne;
} bDiagonal = true; for(nAx=0; nAx<nDim-1; nAx++)
for(nBx=nAx+1; nBx<nDim; nBx++) {
for(nAy=0; nBx-nAx+nAy<nDim; nAy++) {
nBy=nBx-nAx+nAy; bDiagonal &&= (!b[nAx][nAy] || !b[nBx][nBy]);
} for(nAy=nBx-nAx; nAy<nDim; nAy++) {
nBy=nAy-(nBx-nAx);
bDiagonal &&= (!b[nAx][nAy] || !b[nBx][nBy]);
}
}
assert_all(bHorizontal && bVertical && bDiagonal);
However, this modification does not improve efficiency of the solving process. Namely, all constraints that are generated by the former and not by the later specification are trivially discarded and the final generated formulae are identical in the two cases. The formula generation is, still, somewhat more efficient in the latter case, but that gain gets insignificant as the problem instance grow.

Table 4 shows experimental results for the four given representations of the queens problem. For the first representation numbers are represented by vectors of length 5, for the second, numbers are represented by vectors of length equal to the instance size, and for the last two, numbers are represented by vectors of length 4. The table shows times
(in seconds) for finding all solutions, while the timeout was **set at 600s. The first problem**
representation was clearly shown to be the least efficient, while modified version (the second representation) was the best. As expected, the third and the **fourth specification were almost** equal. According to the data, it appears that the second specification was most efficient. However, dealing with output of large number of variables takes a larger portion of time for the last two specifications than for the second one. If used in a "quiet" mode (without listing values of independent variables), the last two specifications are slightly more efficient than the second one. In summary, the specifications based on the bitvector operators and on the direct encoding were more efficient. Of course, even a conclusion about the most efficient sort of encoding for the queens problem should rely on a wider set of specifications and experiments, not to mention considering most efficient sorts of encodings generally. Although some encodings typically perform better than some **other ones, a full picture of**
relative quality of encodings is very complex and each popular encoding has problems where it performs well. Hence, one of the points of presenting different specifications of the queens problem is not to locate the best encodings, but rather to demonstrate that in the ursa system one can make significantly different representations of the same problem.