Note that the specifications given above also cover the information on what variables are unknown and have to be determined so that the constraints **are satisfied - those are** variables that appear within commands before they were defined. So, the above code is a full and precise specification of the problem, up to the domains of the variables. For Boolean variables, the domain is {⊥, ⊤}**, while for numerical variables a common domain** interval (e.g., [0, 2 n − 1]) can be assumed and additional domain restrictions can be **given**
within the specification.

3.2. Problem Solving. The described imperative tests form problem specifications and they can be used as a starting point in problem solving. Let us **first describe a straightforward, naive approach.**
Assume that there is a problem specification (in the form of an **imperative test) and**
assume there is a common domain for all unknowns (except Boolean unknowns), for example, the interval [0, 2 n − 1] (for a given n**). Then, for all admissible values for all unknowns,**
the specification can be executed. All sets of values satisfying the constraints should be returned as solutions. If there are k unknown numerical variables and l **unknown Boolean**
variables, then the search space would be of the size 2nk+l.

Example 3.3. Let us consider the specification given in Example 3.1. If the **domain for**
u and v is the interval [0, **3], the specification should be executed four times and only the** value 1 assigned to u **leads to the constraint met, so it is the only solution of the problem.**
Obviously, the above naive and brute-force approach based on systematic enumeration of all possible input values is complete (for finding all solutions), but extremely inefficient.

It can be turned to a much more efficient version that takes into **account given relationships** between variables in order to reduce the search space. The basic idea is to represent all unknowns abstractly, in a symbolic form, as vectors of propositional formulae. Then, all steps in the specification can be performed using this abstracted form (i.e., can be symbolically executed). Finally, the assertion would generate a propositional formula for which a satisfying valuation is to be found. If there are k **unknown numerical variables and** l unknown Boolean variables, then the number of possible valuations would be 2nk+l**(if the**
interval [0, 2 n − 1] is assumed as the domain for numerical values). Of course, **instead of**
a brute-force search over this set of valuations, a sat **solver should be used (and it will** typically perform many cut-offs and search over just a part of the whole search space).

Representation of numerical variables by propositional formulae corresponds to their binary representation. Each formula corresponds to one bit **of the binary representation.** If the range of a numerical variable is [0, 2 n − **1], then it is represented by a vector of** n propositional formulae. If a bit of the number is known to be 1, then the corresponding formula is ⊤**, and if a bit of the number is known to be 0, then the corresponding formula is**
⊥. For instance, for n = 2, 1 is represented by [⊥, ⊤**] (where the last position corresponds** to the least significant bit). If a bit of the number is not known, then it is represented by a propositional variable, or, if it depends on some conditions, by a propositional formula. We will discuss only representations of unsigned integers, but representations of signed integers can be treated in full analogy (moreover, floating point numbers can also be modelled in an analogous way). Boolean variables are represented by unary vectors of propositional formulae.

Results of arithmetic and bitwise logical operations over numbers represented by vectors of formulae can be again represented by propositional formulae in terms of formulae