# Creating A New Ontology: A Modular Approach

Julia Dmitrieva and Fons J. Verbeek Universiteit Leiden, Leiden Institute of Advanced Computer Science, Niels Bohrweg 1, 2333 CA Leiden, The Netherlands
{jdmitrie,fverbeek}@liacs.nl http://bio-imaging.liacs.nl/
Keywords: **module extraction, ontology mapping, ontology integration**

## 1 Introduction

Ontologies in life sciences, in particular, members of the OBO Foundry **[6],**
contain information about species, proteins, chemicals, genomes, **pathways, diseases, etc. Information in these ontologies might overlap, and it is possible that**
a certain concept is defined in different ontologies from a different point of view and at different level of granularity. Therefore, the combination of information from different ontologies is useful to create a new ontology.

Case Study **The integration will be illustrated with a case study on Toll-like**
receptors. If we want to investigate what kind of information about Toll-like receptors is available in Molecule Role Ontology **(MoleculeRoleOntlogy) [6],**
then we will see that Toll-like receptors are defined as pattern recognition receptors. In the Biological Process Ontology **(GO) [6] the Toll-like receptors**
are described in the context of signaling pathway and are subsumed **by the**
pattern recognition receptor signaling pathway. In the Protein **[6] ontology a** Toll-like receptor is just a protein. In the NCI Thesaurus **[5] ontology Toll-like**
receptors are defined as Cell Surface Receptors**. It follows from foregoing that**
multiple ontologies model different aspects of the same concept and **the combination of the available information provides more knowledge about concepts**
where an ontology developer is interested in.

We introduce an approach for generating a new ontology in which ontologies from OBO Foundry **are reused. First, we extract modules from these ontologies, on the basis of the well defined modularity approach [2]. As a signature**
for the modules we are using the symbols that match the terms of interest as indicated by the user. In our case study we create an ontology about Toll-like receptors, therefore we use two seed **terms (Toll, TLR). Subsequently, we create**
mappings between concepts in the modules. It has already been shown [1] that the simple similarity algorithms outperform structural similarity algorithms in biomedical ontologies. To this end, we have based our mappings on the similarity distance [4] between labels and synonyms of classes in the modules. Finally, a new ontology is created where the mappings are represented by means of owl:equivalentClass axiom and small concise modules are imported.