
## 2 Modules From Enriched Signature

In our case study we have used the following biomedical ontologies obtained from OBO Foundry: National Cancer Institute Ontology (NCI Thesaurus**), GO** Ontology (GO), Protein Ontology (PRO**), Dendritic Cell ontology**
(dendritic cell), Pathway ontology (pathway**), Molecule Role Ontology** (MoleculeRoleOntology), Gene Regulation Ontology (gene **regulation**), and finally, Medical Subject Heading ontology (MeSH**). All of these ontologies** are in OBO format, except for the NCI Thesaurus**, which is in OWL format.**
A module comprises knowledge of a part of the domain that is dedicated to a set of terms of user interest (seed terms). Let T1 = {T oll, T LR} **be this set.** Let S1 be a set of terms (signature) from the ontology O1 **that represents the**
classes whose labels, descriptions, ID, or other annotation properties contain the symbols from T1**. The first module that we have extracted is the module from**
NCI Thesaurus M1**. This is chosen because it is the largest ontology containing**
the most matches. In order to generate a signature for the next ontology O2**, we**
are using not only the terms from T1 **but we enrich this set with the terms from** the module M1**. The same procedure is applied for the rest of the ontologies,**
namely module Miis extracted on the basis of the terms Ti = Sig(Mi−1)∪Ti−1.

This method has two drawbacks. First, it depends on the order of ontologies.

Second, with the generation of the new module Mi **new symbols can be introduced that will match symbols from ontologies used in previous steps. These**
problems can be solved with the generation of a fixpoint.

Fixpoint Modules **We have investigated whether or not we will find a fixpoint**
with our module extraction method. The fixpoint is reached at the moment the set of terms T which is used in order to generate modules during step ti **does not**
change any more after another run with all ontologies. This can be written as ∪
n k=1Sig(Mk,i) = ∪
n k=1Sig(Mk,i+1**), where** Mk,i is the module k **created during**
step ti. It can be formulated in a "fixpoint-like" way M atch(T ) = T .

The fixpoint was reached with the following sizes of the modules, see Table 1.

## 3 Ontology Mapping

In this paper we use a more loosely definition of the concept mapping **compared**
with the definition given in [3] in which mapping is a morphism. In our approach mapping is a partial function that maps from subset S1 ⊆ Sig(O1**) to subset** S2 ⊆ Sig(O2**). We deliberatively reject the morphism requirement, thus, the**
structural dependencies will not be preserved after mapping, because we are interested in consequents of this mapping to the original ontologies, namely, whether and how the structural dependences will be broken.

For our experimental prototype system we use our own mappings based on the syntactic similarity. It has been already shown [1] that in the case of biomedical ontologies the simple mappings methods are sufficient and outperform more complex methods.