Table 1: The size of the modules after reaching the fixpoint

| module                                                                                           | size in KB   |
|--------------------------------------------------------------------------------------------------|--------------|
| Toll from gene regulation                                                                        | 88.7         |
| Toll from protein                                                                                | 23.4         |
| Toll from chebi                                                                                  | 218.6        |
| Toll from mesh                                                                                   | 59.2         |
| Toll from dendritic cell                                                                         | 4.2          |
| Toll from pathway                                                                                | 4.1          |
| Toll from cellular component                                                                     | 35.4         |
| Toll from molecular function                                                                     | 11.4         |
| Toll from MoleculeRoleOntology 46.9 Toll from biological process 221.1 Toll from Thesaurus 802.1 |              |

We compare characteristics (id, label, description) for all classes from ontology O1 with the same characteristics for all classes from ontology O2**. The**
comparison is based on the Levenshtein distance algorithm [4]. We have adapted the Levenshtein distance and introduce a metric Lev (in the range [0 . . . **1]). Two**
classes Ci and Cj **are considered to be similar if they have the maximum value**
for Lev metric and if this value is also higher than the threshold t = 0.**95 that**
was experimentally determined.

## 4 Integration Information From Ontologies

The final step of the ontology creation is the integration of the modules into one ontology. If there a mapping exists between two classes Ci and Cj **from the** modules Mi and Mj **respectively we add the equivalence relation**
owl:equivalentClass **between these classes in the new ontology. Besides the**
equivalence relationships the new ontology contains the OWL:imports **axioms,**
where all the created modules are imported.

So far, this all seems rather straightforward. However, the problem with this integrated ontology O1...n **is that it contains many unsatisfiable classes. In**
order to understand the reason of this unsatisfiability we have applied different experiments. First, we have merged all pairs of the modules, namely ∀i6=jOi,j ≡
Mi∪Mj **. For each merged ontology** Oi,j **we have checked for unsatisfiable classes.**
Already at this stage of integration different merged pairs contain unsatisfiable classes. We have used the Pellet [7] reasoner in order to reveal the **explanations** of unsatisfiability. After we have repaired unsatisfiable classes in the merged pairs of ontologies Oi,j **we have had to check satisfiability of the integrated**
ontology O1...n**. There were still 46 unsatisfiable classes. The unsatisfiabilities**
in the integrated ontology have also been solved by means of Pellet reasoner explanations.