# A Semantic Approach For The Requirement-Driven Discovery Of Web Services In The Life Sciences

Mar´ıa P´erez, Rafael Berlanga, Ismael Sanz Universitat Jaume I, Spain
{mcatalan, berlanga, isanz}@uji.es Abstract. Research in the Life Sciences depends on the integration of large, distributed and heterogeneous data sources and web services. The discovery of which of these resources are the most appropriate to solve a given task is a complex research question, since there is a large amount of plausible candidates and there is little, mostly unstructured, metadata to be able to decide among them. We contribute a semi-automatic approach, based on semantic techniques, to assist researchers in the discovery of the most appropriate web services to fulfill a set of given requirements.

## 1 Introduction

Contemporary research in the Life Sciences depends on the sophisticated integration of large amounts of data obtained by in-house experiments **with reference**
databases available on the web. This is followed by analysis workflows that rely on highly specific algorithms, often available as web services. The amount of data produced and consumed by this process is prodigious; however, the sheer amount of available resources is a source of severe difficulties.

Within this huge set of resources, one of the main problems to the user is finding the right web services for a given research task. The landscape of Life Sciences web services is large and complex: there are thousands of **resources [1],**
most of them available in public repositories, i.e. BioCatalogue [3], but unfortunately only a few are described by adequate metadata, which is essentially textual in nature and this makes the discovery and the integration **difficult. In**
addition, there are many versions of different services that apparently provide the same broad functionality, but not enough metainformation is available to decide which of these services is the most appropriate for a precise **task.**
Given this context, it is a pressing question how to help researchersto discover the best possible mapping between their requirements and the available tools. We present a semi-automatic approach to assist the researcher in **web service**
discovery, looking for web services that are appropriate to fulfill the information requirements in the Life Sciences domain. The whole process is driven **by wellcaptured requirements, in order to avoid the high costs associated with nondisciplined, non-reusable, ad-hoc development of integration applications. The**
matching between the requirements and web services is based on a semantic normalization of both the requirements and the web services metadata.