

![0_image_0.png](0_image_0.png)

In a knowledge engineering process, it is common that non-technical domain experts work together with experienced knowledge engineers. This means that certain advanced functionalities can be hidden for novice users but are available to experienced users. Thus we use **Access Control List** (ACL) to describe privilege control depending on user identity and group affiliation.

WikiBridge supports **annotation functionalities within the same interface**
as the primary data to avoid unnecessary context and application switches. In the meantime, these annotations must be maintained on clearly separated layers to keep integrity and traceability of the primary data. Different types of annotations have been identified: 1) simple annotation allows to tag a subject by describing some of its properties by a set of attribute value couples; 2) nary relation allows to map a subject with two or more values and references to other elements (subjects). In this case, some values properties reference another subject; 3) recursive annotation allows to explain or clarify an attribute by a sub-annotation. To be able to exchange data with other applications (e.g.

ontology editors, Web Services, other wikis), WikiBridge is purely based on existing **Semantic Web standards** such as the Web Ontology Language OWL for describing ontologies and W3C's RDF for annotations. Annotations are stored by RAP as RDF triples, separately from the original document. We explicitly store in a database the conceptual model defining the structure of the domain ontology; ontology is loaded from Protégé by a specific program. **Information**
access has been designed with taking into account some features about users.

We have thus identified an usage typology in accordance to 1) kind of usage:
reader, investigation, clarification; 2) knowledge degree of the domain: domain specialists like biologist researchers and non specialists. Queries are expressed in SPARQL. We consider **reasoning** as one of the most important functionalities as it allows : 1) to emerge knowledge that is not explicit in the data; 2) to check annotations, and 3) to enhance navigation and search. First order logic