to go into an axiom based editor, will increase the quality assurance aspects of Populous.

We have demonstrated how Populous can be used to develop an ontology describing cells of the kidney and urinary pathway system. This demonstration highlights how domain experts managed to generate a real application ontology without being exposed to an ontology language like OWL, or a tool like Prot´eg´e.

Populous's main purpose is for knowledge gathering and not ontologising. By shielded users from the ontology, except for review later in the process, they are left to concentrate on the biology and not worry about the axioms needed to represent it. This separation is particularly useful should the ontologist wish to change the conceptualisation or experiment with different patterns for the representation.

Our experience in developing the KUPO with domain experts provided interesting insights into the benefits of developing an ontology in this way. Classical approaches to ontology development in the life science have tended to focus on building rich asserted hierarchies of concepts. The KUPO approach exploits the expressiveness of an ontology language like OWL to describe the cells in such a way that the class hierarchy is computed by the reasoner. This means we have a logical explanation for all the subsumptions in the hierarchy, that is useful for spotting erroneous or missing information. For example, there are cell types for the vasa recta descending limb and the vasa recta ascending limb, both of which have different functions. The imported anatomy ontology, however, only describes a vasa recta. The domain experts were able to spot this and can now submit a request for these two new concepts to be added to the anatomy ontology. Building normalised ontologies that facilitate the kinds of inferences we see in KUPO are generally considered to be harder and more time consuming than constructing class hierarchies manually, despite offering a clear benefit [17].

However, in cases where a repeating pattern can be abstracted from the ontology, as in the case of KUP cells, we see that domain experts can rapidly produce rich ontologies with considerably less investment using Populous.

The question now arises as to how far can you go with a tool like Populous?

Populous is by no means a replacement for full blown ontology editors, nor is it intended to be. The scenarios where Populous is of benefit assume that the ontology being developed has repeating patterns in the modelling. Furthermore, specifying the patterns for new ontologies before they exist is particularly difficult and is often something that emerges later as the ontology matures. For example, it was assumed with the kidney cells that we could describe them all in terms of their anatomy, only to later find some exceptions to the pattern.

Renal principal and renal intercalated cells are currently indistinguishable by anatomy and function alone. There are always going to be exceptions, especially when modelling a complex domain like biology. We hope that Populous can bring more domain experts into the ontology development process and engage them in the development process.

The template approach can be particularly advantageous in scenarios where the modelling needs to change. [16] showed how templates can be used to gen-