We can abstract over this pattern to say that every cell can be classified by its nucleation. This pattern is repeated for all cell types; the only variables are the cell name and the value for its nucleation. We can now use this pattern to build a simple template that could be populated by a cytologist, without him or her ever knowing about the underlying ontological representation. This type of pattern is common in ontology development where you have one set of entities being described in terms of another set of entities [17].

The tabular layout provides a simple and intuitive form fill-in style of user interface for a user to populate such templates. Typically, each row corresponds to a set of related entities and each column represents the type of relationship.

The intersection of row and column holds the 'filler' for the given entity's relationship of that column's type. By adopting templates ontology developers can separate the pattern from its population; this allows the domain expert to focus on the knowledge without the distraction of the knowledge representation language.

Templates are useful when data needs to be collected in a regular form. Applying constraints to the template reduces the amount of discrepancies in the input data. A common tool for collecting data in this form is the spreadsheet; spreadsheets provide a tabular interface, where columns and rows represent certain attributes, and individual cells capture the data. Tables help users to structure data in a logical way, that is useful for both its maintenance and processing.

In ontology development spreadsheets can be used to gather and organise information about concepts and their relationships. Previous work in this area has focused on the transformation of data into ontologies, but little attention has been paid to supporting the population of the templates at the point of data entry and this is where Populous's main contribution lies.

## 1.1 Previous Work

Various tools are available to support the conversion of spreadsheet data into statements in a knowledge representation language. Excel2RDF3, Convert2RDF4 and RDF123 [1] are three tools that allow users to generate Resource Description Framework (RDF) statements from spreadsheets. Despite RDF being the reference syntax for the Web Ontology Language (OWL), its serialisation is complex and not intended for humans, making it inappropriate for defining higher level OWL construct in patterns.

The ExcelImporter plugin5for Prot´eg´e 4.0 was a step up from these tools and enabled users to transform spreadsheets content directly into OWL axioms.

It was, however, limited to only a small set of OWL constructs. The more recent tools to support template data and pattern instantiation include Mapping Master [14], OPPL 2 [11,6] and the Prot´eg´e Matrix plugin6:
3http://www.mindswap.org/~rreck/excel2rdf.shtml 4http://www.mindawap.org/~mhgoeve/convert/
5http://protegewiki.stanford.edu/wiki/Excel_Import 6http://protegewiki.stanford.edu/wiki/Matrix