# Querying Biomedical Ontologies In Natural Language Using Answer Set Programming

Halit Erdogan 1, Umut Oztok 1, Yelda Erdem 2, and Esra Erdem 1 1Faculty of Engineering and Natural Sciences, Sabancı University, ˙Istanbul, Turkey 2 Research and Development Department, Sanovel Pharmaceutical Inc., ˙Istanbul, Turkey Recent advances in health and life sciences have led to generation of a large amount of data. To facilitate access to its desired parts, such a big mass of data has been represented in structured forms, like biomedical ontologies. On the other hand, representing ontologies in a formal language, constructing them independently from each other and storing them at different locations have brought about many challenges for answering queries about the knowledge represented in these ontologies. One of the challenges for the users is to be able represent a complex query in a natural language, and get its answers in an understandable form: Currently, such queries are answered by software systems in a formal language, however, the majority of the users lack the necessary knowledge of a formal query language to represent a query; moreover, none of these systems can provide informative explanations about the answers. Another challenge is to be able to answer complex queries that require appropriate integration of relevant knowledge stored in different places and in various forms.

In this work, we address the first challenge by developing an intelligent user interface that allows users to enter biomedical queries in a natural language, and that presents the answers (possibly with explanations if requested) in a natural language.

We address the second challenge by developing a rule layer over biomedical ontologies and databases, and use automated reasoners to answer queries considering relevant parts of the rule layer. The main contributions of our work can be summarized as follows: 

- We introduce a controlled natural language, a subset of natural language with a restricted grammar and vocabulary, specifically for biomedical queries towards drug discovery; we call this controlled natural language as BIOQUERYCNL [4]. For instance, in this language, we can pose the following query:
"What are the genes that are targeted by the drug Epinephrine and that interact with the gene DLG4?"
- We present an algorithm that converts a biomedical query in BIOQUERYCNL into a program in answer set programming (ASP) - a formal framework to automate reasoning about knowledge [8] - making use of the parsing engine APE [5]. Figure 1 shows the overall idea behind this algorithm. For instance, according to this algorithm, the query above is translated into the following ASP program:
what_be_genes(GN1) :-
gene_gene(GN1,"DLG4"),
drug_gene("Epinephrine",GN1).