# Descriptive-Complexity Based Distance For Fuzzy Sets

Laszlo Kovacs∗ and Joel Ratsaby†
November 10, 2018

## Abstract

A new distance function dist(*A, B*) for fuzzy sets A and B is introduced. It is based on the descriptive complexity, i.e., the number of bits
(on average) that are needed to describe an element in the symmetric difference of the two sets. The distance gives the amount of additional information needed to describe any one of the two sets given the other.

We prove its mathematical properties and perform pattern clustering on data based on this distance.

Key words: Fuzzy sets, descriptive complexity, entropy, distance.

## 1 Introduction

The notion of distance between two objects is very general. Distance metrics and distances have now become an essential tool in many areas of mathematics and its applications including geometry, probability, statistics, coding/graph theory, data analysis, pattern recognition. For a comprehensive source on this subject see [4]. The notion of a fuzzy set was introduced by [8]. It is a class of objects with continuous values of membership and hence extends the classical definition of a set (to distinguish it from a fuzzy set we refer to it as a crisp set). Formally, a fuzzy set is a pair (*E, m*) where E is a set of objects and m is a membership function m : E → [0, 1]. Fuzzy set theory can be used in a wide range of domains in which information is incomplete or imprecise, such as pattern recognition, decision theory. The concept of distance and similarity is important in the area of fuzzy logic and sets. We now review some common ways of defining distances on fuzzy sets (see [9] and references therein).

Classical distances measure how far two points are in Euclidean space. For instance, the Minkowski distance between two points x and y in R
n is defined as

$$d_{r}(x,y):=\left(\sum_{i=1}^{n}|x_{i}-y_{i}|^{r}\right)^{1/r},\quad r\geq1.$$
$$(1)$$
