Let E be a finite set and let Φ(E) be the set of all fuzzy subsets of E. Consider A,B two fuzzy subsets A, B ∈ Φ(E) with membership functions mA,mB : E →
[0, 1]. Then (1) can be extended to the following distance,

$$d_{r}(A,B):=\left(\sum_{x\in E}|m_{A}\left(x\right)-m_{B}(x)|^{r}\right)^{1/r},\quad r\geq1.$$

Based on (1) letting r = 2 we have the Hausdorff distance between two nonempty compact crisp sets U, V ⊂ R,

$$q\left(U,V\right):=\max\left\{\sup_{v\in V}\inf_{u\in U}d_{2}\left(u,v\right),\sup_{u\in U}\inf_{v\in V}d_{2}\left(u,v\right)\right\}.\tag{2}$$

This can be extended to fuzzy sets as follows: let A ∈ Φ(E) be a fuzzy set and denote by Aα the α-level set of the fuzzy set A which is defined as Aα =
{x ∈ E | mA(x) ≥ α}. Then for two fuzzy subsets A, B ∈ Φ(E) the distance in
(2) can be extended to the following distance between A and B,

$$q(A,B):=\int_{0}^{1}q(A_{\alpha},B_{\alpha})d\alpha.$$

Another approach is based on set-theoretic distance functions. For a fuzzy set A ∈ Φ(E) define the cardinality of A as |A| =Px∈E mA(x). Extend the intersection and union operations by defining the membership functions mA∩B(x) := min {mA(x), mB(x)}
and mA∪B(x) := max {mA(x), mB(x)} .

Then for fuzzy sets A, B ∈ Φ(E) we may define the distance function

$$S_{1}(A,B):=1-{\frac{|A\cap B|}{|A\cup B|}}=1-{\frac{\sum_{x\in E}m_{A\cap B}(x)}{\sum_{x\in E}m_{A\cup B}(x)}}.$$

Another distance is based on four features of a fuzzy set. Let the domain of interest be R and consider a fuzzy set A in Φ(R). The power of A (which extends the notion of cardinality) is defined as

$$\mathrm{power}\left(A\right):=\int_{-\infty}^{\infty}m_{A}(x)d x.$$
$$\mathrm{power}\left(A\right):=\int_{-\infty}^{\infty}m_{A}(x)dx.$$  Let $S(x)=-x\ln x-(1-x)\ln(1-x)$ then define the entropy of $A$ as  $$\mathrm{entropy}\left(A\right):=\int_{-\infty}^{\infty}S(m_{A}(x))dx.$$  Define the centroid as  $$c(A):=\frac{\int_{-\infty}^{\infty}x m_{A}(x)dx}{\mathrm{power}\left(A\right)}$$
