From an information theoretic perspective, this property is expected since knowing a set A automatically means that we also know how to describe its complement. Hence there is no additional description necessary to describe A given A.

This is what dist(A, A) = 0 means.

Let us now consider some examples of pairs of fuzzy sets and their distances.

Let N = 20 and the domain be [N] = {1, 2*, . . . ,* 20}. In the following examples we plot the membership functions of several fuzzy sets. Note, we connect the point values of the membership function by lines in order to make the plots clearer (remember that the actual membership functions are defined only on the discrete set [N]).

Example 4. Consider the fuzzy sets A,B,C and the complement Ac with membership functions as shown in Figure 1. Note, that A and its complement are crisp sets. The distance matrix D = [di,j ] *is shown in (8); the rows and* columns correspond to A, B, C and Ac*so that for instance the element* d2,3 =
dist(*B, C*) = 0.709. As can be seen, C is a translated version of B *and they are* both the same distance from A*. This is due to* H(XAMB(x)) = H(XAMC (x+10)).

B and C are farther apart than B and A. Since dist(*A, A*c) = 0 *then each one* of B, C is of the same distance to A *as to* Ac.

$\overline{\phantom{\rule{0.000pt}{0ex}}\phantom{\rule{0.0000pt}{0ex}}}$
D =

$$\bigstar\bigstar$$
 $\begin{array}{cc}0.354&0.354\\ 0&0.709\\ 0.709&0\\ 0.354&0.354\end{array}$  . 
$\begin{array}{cc}(&0\\ &\\ 0.354\\ &\\ 0.354\\ &\\ 0\end{array}$  ×
0 0.354 0.354 0
0.354 0 0.709 0.354
0.354 0.709 0 0.354
0 0.354 0.354 0
$$\left.\begin{array}{c}{{0}}\\ {{0.354}}\\ {{0.354}}\\ {{0}}\end{array}\right\}\qquad\qquad(8)$$
Example 5. Continuing with the same domain as in Example 4 *let us consider* the fuzzy sets A,B,C and the complement Ac *with membership functions as* shown in Figure 2. The membership function of the set C *is now flat and as the* distance matrix D = [di,j ] in (9) shows C is now farther from B *(which has a* triangular membership function). As in the previous example B remains closer to A than to C.

$\overline{\overline{\phantom{\rule{0.00167em}{0ex}}}}$
D =
$$\left(\begin{array}{c c}{{0}}\\ {{0.354}}\\ {{0.5}}\\ {{0}}\end{array}\right)$$
 $\begin{array}{cc}0.354&0.5\\ 0&0.854&0\\ 0.854&0\\ 0.354&0.5\end{array}$
0.354 0 0.854 0.354
0.5 0.854 0 0.5
$$\left.\begin{array}{c}{{0}}\\ {{0.354}}\\ {{0.5}}\\ {{0}}\end{array}\right\}\qquad\qquad\qquad(9)$$
Example 6. Continuing with the same domain as in Example 4 *let us consider* the fuzzy sets A,B,C and the complement Ac with membership functions as shown in Figure 3. Note that now C is translated from B *by an amount that* is smaller compared to Example 4. As can be seen from the distance matrix of
(10) this results in a smaller distance dist(*B, C*) = 0.336 *compared to* 0.709.

As in Example 4 , A is as similar to B as to C since the distance dist(*A, B*) =
dist(*A, C*) = 0.354.

$$D=\left|\begin{array}{l}{{}}\\ {{}}\\ {{}}\end{array}\right.$$

$$\left.\begin{array}{c c c c}{{0}}&{{0.354}}&{{0.354}}&{{0}}\\ {{0.354}}&{{0}}&{{0.336}}&{{0.354}}\\ {{0.354}}&{{0.336}}&{{0}}&{{0.354}}\\ {{0}}&{{0.354}}&{{0.354}}&{{0}}\end{array}\right)\tag{10}$$
