
## 5 Clustering Using The Distance

We tested the proposed distance function on real data. The data1consists of answers from a survey given to the general population of 28 European countries.

There are ten questions in the survey where a valid answer is a number in the set {1*, . . . ,* 10}. The value 10 represents the most positive opinion and 1 the most pessimistic opinion (we denote the name of the attribute in parenthesis):
- trust in local parliament (country_GOV)

- trust in local politicians (politicians)
- trust in EU Parliament (EU_GOV)
- trust in United Nations (UN)
- trust in country's parliament (country_GOV)
- how satisfied with life (Life)
- how satisfied with the national government (National_GOV)
- immigration is bad or good (Immigration) - the state of health services (Health)

## - How Happy Are You (Happy)

After normalizing each component we represent each country as a fuzzy set on a domain that consists of the ten attributes. Table 1 displays the membership functions for each of the countries. Each row in this table represents a membership function mi(x) of the fuzzy set Ci of country i. Based on this information we compute the distance d(Ci, Cj ) between every possible pair of countries Ci, Cj and obtain a distance matrix D = [di,j ], di,j := dist(Ci, Cj ).

We use D as the newly transformed version of the original data (Table 1) and do data-clustering on it. The i th row of D is a feature vector representation of country i. We use the k-means clustering procedure.

Figure 4 shows the result of the k-means clustering where the horizontal axis displays the cluster number and the vertical axis shows the distance of each point in a cluster to the mean of the cluster. In order to interpret this result, let us look at the fuzzy sets of some of the clusters. Figure 5 displays the fuzzy sets of cluster \#1. As seen, the country Spain is considered similar to the rest of the countries in this cluster although its "happy" value is almost complement to the rest of the countries. This follows from the complement-property of our distance function (see section 4).

Figure 6 displays the fuzzy sets of cluster \#2. Ukraine seems to behave almost the opposite of Denmark (besides on the attributes EU_Gov where both have similar values). Ukraine and Turkey have interesting behaviors: they take very similar values for the attributes country-GOV up to Life and on UN while on the rest of the attributes they are almost mutually complement. Hence 1The data set is the European Social Survey Round 4 Data (2008). Data file edition 3.0.

Norwegian Social Science Data Services, Norway - Data Archive and distributor of ESS data. http://ess.nsd.uib.no/.