# Automatic Estimation Of The Exposure To Lateral Collision In Signalized Intersections Using Video Sensors

Nicolas Saunier∗ and Sophie Midenet†
October 29, 2021

## Abstract:

Intersections constitute one of the most dangerous elements in road systems. Traffic signals remain the most common way to control traffic at high-volume intersections and offer many opportunities to apply intelligent transportation systems to make traffic more efficient and safe. This paper describes an automated method to estimate the temporal exposure of road users crossing the conflict zone to lateral collision with road users originating from a different approach. This component is part of a larger system relying on video sensors to provide queue lengths and spatial occupancy that are used for real time traffic control and monitoring. The method is evaluated on data collected during a real world experiment.

## 1 Introduction

Collisions at intersections make up a high proportion of total collisions all over the world, 39.7 % of all collisions and 21.8 % of fatal collisions in the US for instance (NHTSA,
2008). Traffic signals are installed at intersections according to warrants on traffic volumes and safety. Over the years, there has been considerable interest in improving signalized intersections to minimize delays and stops. It has become possible to develop traffic control strategies that can adapt to current traffic conditions in real-time thanks to the advancement of sensors. However not much is known about the impact on safety of traffic control strategies, particularly adaptive ones.

The CRONOS strategy is a real-time adaptive traffic control strategy developed in the 1990s (Boillot et al., 2006). It relies on video sensors that provide queue lengths and spatial occupancy rates every second (Aubert et al., 1996). Its algorithm controls the traffic lights in order to minimize total delay over a short-range time horizon. The CRONOS strategy was compared to a standard time-plan based control strategy with vehicle-actuated ranges. During the real world experiment, the two strategies alternately controlled a real intersection in the suburbs of Paris over several months. The traffic databases recorded during the CRONOS strategy assessment enable us to obtain quantitative results in a real world setting and to compare the exposure between strategies and between traffic volume conditions.

∗Ecole Polytechnique de Montr´eal, C.P. 6079, succ. Centre-Ville, Montr´eal Qu´ebec, Canada, H3C 3A7. ´
Tel.: +1 (514) 340-4711 (ext. 4962). Fax: +1 (514) 340-3981. Email: nicolas.saunier@polymtl.ca. Website: http://nicolas.saunier.confins.net
†Universit´e Paris-Est, INRETS, GRETIA, 2 rue de la Butte Verte, 93166 Noisy-le-Grand cedex, France.

Email: sophie.midenet@inrets.fr arXiv:1012.4776v1 [cs.AI] 21 Dec 2010