The exposure to lateral collision in intersections is defined as the temporal duration of critical situations, which occur when the stream that is given right-of-way by the signal goes through the conflict zone while there is at least one road user in the cross-traffic approach. In the simple case of a signalized intersection of two one-way roads (see Figure 1), a road user enters the conflict zone from one of the two approaches, denoted A and B. Let us consider a given period T and one of the two traffic streams originating from the two approaches, say A. We adopt the following definitions, illustrated in Figure 2.

- Duration Z(A) is the cumulated amount of time during which road users of stream A are crossing the conflict zone within period T.
When road users of stream A are crossing the conflict zone, there are two possible situations: absence or presence of road users in the cross-traffic approah B.

- Duration X(A) is the cumulated amount of time during which road users of stream A are crossing the conflict zone when B is empty.

- Duration Y (A) is the cumulated amount of time during which road users of stream A are crossing the conflict zone when road users are present in B.
It follows that: Z(A) = X(A) + Y (A). Y (A) can be further sub-divided by considering whether all the close road users in B
are stationary or at least one close road user is moving in B (Figure 2). A close road user is a road user in the cross traffic approach such that there is no other road user between itself and the conflict zone, e.g. the first road user in each lane of an entry cross traffic approach. Ym(A) is the cumulated amount of time during which road users of stream A are crossing the conflict zone when at least one close road user is moving in B, with Ym(A) ≤ Y (A). The definitions are symmetric with respect to A and B.

![0_image_0.png](0_image_0.png)

## 3 Data Description

The system used in this work extracts spatial occupancy measurements of the whole intersection from video sensors. It can be seen as a virtual grid of sensors covering the surface