
## Abductive Reasoning

Abduction (see e.g. [4]), first described by Peirce more than a hundred years ago, is the process of arriving at the premise which would 'explain' some situation. Given that the set of propositions C
formally follows from the set of propositions A subject to the set of logical rules T, then the derivation of C from T and A is deduction, that of T from C and A is induction, and that of A from T and C is abduction. Note that the abduced set is sufficient, but not necessary for C to follow from T, and may be one of many alternatives; in abduction one also usually looks for the most natural explanation in the form of the most economical one. Given a set of true propositions, then, an abduced proposition is a plausible proposition. Plausibility then is a measure of how good is the proposition in explaining the available facts. It can be related to how much of the requirement for sufficiency has been satisfied.

## Bayesian Probabilities

When propositions have probabilistic values, then abduction is related to conditional probabilities. Bayes' theorem states that the probability for θ given x, P(θ |x) = P(x |θ ) P(θ ) / P(x)
depends on the conditional probability, or likelihood, of x given θ, multiplied by the prior probability for θ. Abduction being the 'reverse' of deduction is parallel to the conditional probability being the 'reverse' of likelihood. Conditional probabilities then present a possible model for plausibilities. Combinations of plausibilities in inferences can copy those in Bayesian networks [5]. However, the determination of prior probabilities pose a problem for calculating conditional probabilities. 

## Dempster-Shafer Theory

The Dempster-Shafer theory of evidence [3] has its own definition for plausibility which is based on some belief function. Plausibility for a set of propositions is the sum of "belief masses" of other sets of propositions which intersect with this set, while belief is that for those which are subsets, and they bound the probability:
bel(X) ≤ P(X) ≤ pl(X)
and are related, pl(X) = 1 - *bel(*¬X).

The theory prescribes a method for combining belief masses from different assignments, along the lines of Bayesian theory. To obtain the plausibility of a combined set of propositions, one has to recalculate using the primary definition. The assignment of belief masses is problematic here, and also, their association with probabilities is misleading. Furthermore, plausibility being the upper bound for belief suggests a rather subjective definition. 