
## Biconditionality And Collins-Michalski

A theory for plausible reasoning has been proposed by Collins and Michalski [6]. It has several types of inferences, namely mutual implication, mutual dependency, generalization, specialization, and similarity/analogy. A drawback is that it has a restrictively large number of parameters to model uncertainty.

The inferences existing in Collins-Michalski theory are mostly explained by biconditionality, wherein implications are taken to also include some degree of equivalences [7]. This relates to abduction, as abduction coincides with deduction when implications are replaced by equivalences. In the probabilistic picture, this is like equating the conditional probability to the likelihood, P(θ |x) = P(x |θ )
Of course this is not rational; after all, this is plausible reasoning. However, this supports the notion that plausibility has an abductive basis.

## Connectionist

It has been shown [8,9] that logic can be hardwired onto a Hopfield neural network [10]. The Hopfield network minimizes a Lyapunov or "energy" function related to the synaptic strengths [11]. By writing an expression yielding a value proportional to unsatisfied clauses, the network then searches for an optimum logical interpretation of the propositional atoms, represented by neurons. This then gives the values for the synapses. In some sense, the logic is contained in the synapses. From the synaptic strengths then, we can make inferences about the logical clauses [12]. This may be helpful in our search for a measure of plausibility.

## Plausibility, Plausibly

Finally, we can make some preliminary moves in the direction of plausibility. Taking an abductive interpretation, the more of the set of existing 'measured' propositions C a hypothetical proposition Ai forces, the more plausible Ai should be. Perhaps then the plausibility of Ai corresponds to the fraction of propositions in C that is forced correct (both, either true or false) by Ai. If Ai does not have any effect on C then Ai should have plausibility 0, and if forces all of the known propositions C to be correct, then Ai have plausibility 1. What is of interest is the combination of plausibilities. Is it possible to have simple combining rules for conjunctions and disjunctions, for example? For propositions Ai and Aj each forcing disjoint subsets of C and having no joint effects on the correctness of any subset, then simply pl(Ai∧ Aj) = pl(Ai) + *pl(A*j).

In the case of the existence of some common proposition Ci forced by both Ai and Aj, i.e. the rule base T
contains Ai → Ci Aj → Ci then the value is less, as also implicated by the upper limit of 1 on the value of plausibilities, while in the case that Ai and Aj have a joint effect on Ci, e.g.

Ai∧ Aj → Ci