
## 3.2 Elementary Loops Of Disjunctive Programs

In this section, we generalize the definition of an elementary loop to disjunctive programs.

A loop of a disjunctive program can be defined without referring to a **dependency**
graph, as in Proposition 1.

Propositiond 1 For any disjunctive program Π and any nonempty set X **of atoms that occur in Π,** X is a loop of Π iff, for every nonempty proper subset Y of X**, there is a rule (12)**
in Π such that A ∩ Y 6= ∅ and B ∩ (X \ Y ) 6= ∅.

Proof. *From left to right:* Assume that X is a loop of Π. If X **is a singleton, it is**
clear. If X is not a singleton, take any nonempty proper subset Y of X**. Since both** Y and X \ Y are nonempty, there is a path from some atom in Y **to some atom in** X \ Y **in the dependency graph of Π such that all vertices in the path belong to** X. This implies that there is an edge from an atom in Y to an atom in X \ Y **, i.e.,** A ∩ Y 6= ∅ and B ∩ (X \ Y ) 6= ∅ **for some rule (12) in Π.** From right to left: Assume that X **is not a loop of Π. Then the subgraph of the** dependency graph of Π induced by X **is not strongly connected. Consequently, there** is a nonempty proper subset Y of X **such that no edge connects an atom in** Y to an atom in X \ Y **. This implies that there is no rule (12) in Π such that** A ∩ Y 6= ∅ and B ∩ (X \ Y ) 6= ∅.

For any set X of atoms and any subset Y of X, we say that Y is *outbound* in X
for a disjunctive program Π if there is a rule (12) in Π such that
- A ∩ Y 6= ∅, - B ∩ (X \ Y ) 6= ∅, - A ∩ (X \ Y ) = ∅**, and**
- B ∩ Y = ∅.

As with nondisjunctive programs, for any nonempty set X **of atoms that occur** in Π, we say that X is an *elementary loop* **of Π if all nonempty proper subsets of** X are outbound in X **for Π. Clearly, every singleton whose atom occurs in Π is an**
elementary loop of Π, and every elementary loop of Π is a loop of Π. The **definition**
of an elementary loop of a disjunctive program is stronger than the **alternative**
characterization of a loop provided in Propositiond **1: it requires that the rule (12)**
satisfy two additional conditions, A ∩ (X \ Y ) = ∅ and B ∩ Y = ∅.

To illustrate the definition of an elementary loop of a disjunctive program, consider the loop {p, q, r} of the program in (10). The loop is not an elementary loop because, for instance, {p} is not outbound in {p, q, r}**: although the first two rules (12)**
in (10) are such that A∩ {p} 6= ∅, B ∩ {q, r} 6= ∅, and B ∩ {p} = ∅**, we also have that** A∩ {q, r} 6= ∅ for each of them. Similarly, {q} and {r} are not outbound in {**p, q, r**}.

On the other hand, the remaining loops of the program, {p}, {q}, {r}, {p, q}, {**p, r**},
and {q, r}**, are elementary loops.**
With the extended definitions given above, Propositions 2, 3, 4 and Theorem 1 (d)
remain correct after replacing "nondisjunctive program" in their statements with
"disjunctive program." In the following, we present proofs for these generalizations.