By referring to elementary loops in place of loops in the definition of an HCF
program, we define a class of programs that is more general than HCF programs: we say that a disjunctive program Π is Head-Elementary-loop-Free (HEF) if |A∩Y | ≤ 1 for every rule (12) of Π and every elementary loop Y **of Π. Since every elementary** loop is also a loop, it is clear that every HCF program is an HEF program as well. However, not all HEF programs are HCF. For example, consider **the following**
program Π2:
p ← r
$$\begin{array}{l}{{p\leftarrow r}}\\ {{q\leftarrow r}}\\ {{r\leftarrow p,q}}\\ {{p~;~q\leftarrow~.}}\end{array}$$
This program has six loops: {p}, {q}, {r}, {p, r}, {q, r}, and {p, q, r}**. Since the**
head of the last rule contains two atoms from the loop {p, q, r}, Π2 **is not HCF.** On the other hand, Π2 is HEF since {p, q, r} is not an elementary loop of Π2**: its** subsets {p, r} and {q, r} are not outbound in {p, q, r} **for Π**2.
Let us write a rule (12) in the following form:
a1; . . . ; ak ← B, F . **(49)**
Gelfond *et al.* (1991) defined a mapping from a disjunctive program Π to a nondisjunctive program Πsh , the *shifted variant* **of Π, by replacing each rule (49) with**
k > 1 in Π by k **new rules:**
ai ← B, F, not a1 , . . . , not ai−1 , not ai+1 , . . . , not ak . **(50)**
They showed that every stable model of Πsh **is also a stable model of Π. Although** the converse does not hold in general, Ben-Eliyahu and Dechter (1994) showed that the converse holds if Π is HCF. We below extend this result to HEF programs.

The following proposition compares the elementary loops of Π with the **elementary loops of Π**sh .

Proposition 7 For any disjunctive program Π, if X is an elementary loop of Π, then X **is an**
elementary loop of Πsh .

Proof. Assume that X **is an elementary loop of Π. Then every nonempty proper**
subset Y of X is outbound in X **for Π, so that there is a rule (49) in Π such that**

$$\{a_{1},\ldots,a_{k}\}\cap Y\neq\emptyset\ ,$$
{a1, . . . , ak} ∩ Y 6= ∅ , **(51)**
$\left(51\right)^3$
$$B\cap(X\setminus Y)\neq\emptyset\ ,$$
B ∩ (X \ Y ) 6= ∅ , **(52)**
$$\{a_{1},\ldots,a_{k}\}\cap(X\setminus Y)=\emptyset\;,$$

and

$\left(52\right)$ . 
$$B\cap Y=\varnothing\ .$$
$\left(53\right)$ . 
B ∩ Y = ∅ . **(53)**
For some ai ∈ {a1, . . . , ak} ∩ Y , (51) implies that some rule (50) in Πsh **satisfies**
{ai} ∩ Y 6= ∅