For any disjunctive program Π, any set X **of atoms, and any bounding loop** Y
of Π w.r.t. X, if ΠX,Y is HEF, then Y **contains a nonempty unfounded set for Π**
w.r.t. X.

Proof. Assume that ΠX,Y is HEF. From the definition of a bounding loop, it follows that all atoms of Y occur in ΠX,Y and that Y = RωΠ,X(Y ) = Rω
(ΠX,Y ),X(Y ) ⊆ X.

By Proposition 16, we conclude that Rω
(ΠX,Y ),X(Y **) contains an elementary loop** Z
of ΠX,Y that is unfounded by ΠX,Y w.r.t. X. From the definition of ΠX,Y **and since**
Z is contained in Y , we conclude that Z **is also unfounded by Π w.r.t.** X.

Proposition 20 tells us that the existence of a bounding loop Y **of Π w.r.t.** X
whose associated subprogram ΠX,Y **is HEF is already sufficient to conclude that** X
is not a stable model of Π. Reconsidering the bounding loop Z = {p, q, r} **of Π**4 w.r.t. X = {p, q, r, s, t, u}, we have that (Π4)X,Z**, consisting of the rules in the first**
column along with the disjunctive rule containing p and q **in the head, is HEF**
(neither {p, q} nor {p, q, r} is an elementary loop of (Π4)X,Z). Thus X **is not a**
stable model of Π4. Indeed, Z **contains two (elementarily) unfounded sets for Π**4 w.r.t. X: {p, r} and {**q, r**}.

## 7 Conclusion

The notion of an elementary loop and its properties provide useful insights into the concept of a loop and the relationship between nondisjunctive programs and disjunctive programs. By turning to the notion of an elementary loop in place of a loop, we could strengthen the theorem by Lin and Zhao (2004), its generalization to disjunctive programs (Lee and Lifschitz 2003), and the main theorem (for programs in canonical form) from (Lee 2005). The semantic (e.g., Theoremd **2) and**
complexity-theoretic (e.g., Theorem 4) properties of elementary loops indicate their close relationship to unfounded sets. Compared with loops, elementary loops provide a deeper understanding of the internal structure of unfounded sets. In fact, we have shown that loop formulas of non-elementary loops are unnecessary for checking the stability of a model. It is an interesting open question whether **this result**
can be used to improve computation performed by answer set solvers that calculate loop formulas, such as assat, claspd**, and** cmodels.

A method to identify an elementarily unfounded set for an HEF program was presented in (Gebser et al. 2007).14 **An orthogonal approach is implemented in**
claspd: it greedily adds atoms a to an unfounded set Y if Y ∪ {a} **stays unfounded**
and has a shorter loop formula than Y **. However, the potential of unfounded set** "optimization" has not been studied in-depth so far, and the theoretical foundations laid here may be useful for future investigations in this direction. Regarding nondisjunctive programs, elementary loops can be distinct from loops of programs called
"binary" (Janhunen 2006). Moreover, modularity aspects of disjunctive stable models (Janhunen et al. 2009), which are closely related to loop formulas **(Lemma 5.4**
from (Janhunen et al. 2009)), can be refined by referring to elementary loops in