# Extending Binary Qualitative Direction Calculi With A Granular Distance Concept: Hidden Feature Attachment

Reinhard Moratz Spatial Information Science and Engineering National Center for Geographic Information and Analysis (NCGIA)
University of Maine 5711 Boardman Hall Orono, ME 04469, USA
October 25, 2018

## Abstract

In this paper we introduce a method for extending binary qualitative direction calculi with adjustable granularity like **OPRA**mor the star calculus with a granular distance concept. This method is similar to the concept of extending points with an internal reference direction to get oriented points which are the basic entities in the **OPRA**mcalculus. Even if the spatial objects are from a geometrical point of view infinitesimal small points locally available reference measures are attached. In the case of **OPRA**m, a reference direction is attached. The same principle works also with local reference distances which are called elevations. The principle of attaching references features to a point is called hidden feature attachment.

## 1 Introduction

A *qualitative* representation provides mechanisms which characterize central essential properties of objects or configurations. A *quantitative* representation establishes a measure in relation to a unit of measurement which has to be generally available.

Qualitative spatial calculi usually deal with elementary objects (e.g., positions, directions, regions) and qualitative relations between them (e.g., "adjacent", "on the left of",
"included in").

The constant general availability of common measures is now self evident. However, one needs only remember the example of the history of technologies of measurement of length to see that the more local relative measures, which are qualitatively represented, (for example, "one piece of material is longer than another" versus "this thing is two meters long") can be managed by biological/epigenetic cognitive systems much more easily as absolute quantitative representations. Typically, in Qualitative Spatial Reasoning relatively coarse distinctions between configurations are made only. The two main trends in Qualitative Spatial Reasoning are topological reasoning about regions [11, 13, 2] and positional reasoning about point configurations [4, 3, 6, 7, 12].