# Learning A Representation Of A Believable Virtual Character'S Environment With An Imitation Algorithm

Fabien Tenc´e∗,∗∗, C´edric Buche∗, Pierre De Loor∗ **and Olivier Marc**∗∗
∗ **UEB - ENIB - LISyC**
∗∗ **Virtualys**
Brest - France
{tence,buche,deloor}**@enib.fr, olivier.marc@virtualys.com**
KEYWORDS

Autonomy, believability, behaviours, imitation learning, topology.

## Abstract

In video games, virtual characters' decision systems often use a simplified representation of the world. To increase both their autonomy and believability we want those characters to be able to learn this representation from human players. We propose to use a model called growing neural gas **to learn by imitation the topology**
of the environment. The implementation of the model, the modifications and the parameters we used are detailed. Then, the quality of the learned representations and their evolution during the learning are studied using different measures. Improvements for the growing neural gas to give more information to the character's model are given in the conclusion.

## Introduction

One of the major goals of video games is to make the user feel like he/she really is in the game environment. To achieve this, it is possible to use complex devices to increase immersion **like surround sound systems and stereoscopic screens. Another way is to make**
rich environments to increase presence**. The latter can**
be done by, among other things, having characters with believable behaviours (Bates 1994). To generate those behaviours, models from artificial intelligence are used in the game industry. For those models to perceive the environment, game designers have to create a simplified representation of the environment, which is often defined **a priori**.

Defining by hand every new environment's representation is a time-consuming work. We propose that our characters will be able to learn those representations, for them to be autonomous. This learning will be unsupervised and online: the character will learn while it plays without the judgement of a human. To be able to achieve the best believability, we want the computercontrolled characters to do like human-controlled characters. Indeed, there are no better example of what a believable behaviour is than a human behaviour itself. It is this kind of learning, by example (Del Bimbo A., Vicario E. 1995) or by imitation (Gorman and Humphrys 2007; Bauckhage et al. 2007) we want to use to learn a representation of the environment.

This article first presents the **growing neural gas**
model which is used to learn the representation of the environment. Then the characteristics and qualities of the learned representations are assessed by different measures. To conclude, some enhancements are proposed for the growing neural gas to give more information to the character's model.

## Learning A Representation Of The Environment

Models which control virtual characters use different types of representation to find paths to go from one point to another. Classic approaches use a graph: nodes represent accessible places and edges represent paths between each place. Actual solutions tend to use a mesh, with different degrees of complexity, to represent the zones where the character can go. The problem with the latter solutions is that they use algorithms to find the optimal path between two points and not the most believable path. With graphs, it is possible to have more control on the paths used by the character.

Instead of designing graphs a priori**, we want them to**
be learned by imitation of a human player. This work as been done in (Thurau et al. 2004) where nodes and a potential field are learned from humans playing a video game. The character is then using this representation to move in the game environment, following the field defined at each node. To learn the position of the nodes, Thurau use an algorithm called Growing Neural Gas (GNG).

The GNG (Fritzke 1995) is a graph model which is capable of incremental learning. Each node has a position (x,y,z) in the environment and has a cumulated error which measures how well the node represents its