
| Frequency   | Time   | Number of nodes   | Error   |
|-------------|--------|-------------------|---------|
| 1Hz         | 1h30   | 22                | 3800 UU |
| 10Hz        | 5min   | 24                | 3300 UU |
| 100Hz       | 5min   | 39                | 2300 UU |

Figure 8: Comparison of growing neural gas' characteristics learned at different frequencies on a simple map
(Training Day). Time, number or nodes and error are given when the growing neural gas reach a stable state. UU stands for Unreal units. give also information on the accessibility of a node from another. Edges in a GNG gives only an information on proximity but there can be a obstacle between two nodes joined by an edge. An idea could be to store the previously activated node and create an edge to the current activated node. Like the GNG edges we should make the edge age and disappear if they are too old. Whether those edges should replace the GNG edges could be an interesting experiment to set up.

To share more information with the behaviour model, we can learn which kind of action is done when the character is near a node. The character, knowing its nearest node, can choose the best action to do. This process is quite similar to the process of tagging: designers often annotate navigation points with information such as
"jump spot" or "covering".

Another interesting information to learn is if the demonstrator walk exactly at the node's position or if there is a big variation in the distance to the node. The nodes' error give a bit of information about this variation, however with the error decay, this information is lost over time. The learning is problematic because each winner node moves so it does not represent the same area. It could be possible to update the influence radius of winner and its neighbours according to their current radius and the distance to the example. The exact formula is yet to be found.

## Conclusion

Virtual environments, like for example video games, need believable characters for users to feel in the environment. To improve the characters' behaviour, we decided to use a growing neural gas to learn by imitation the topology of the environment. We believe that it will make the agent use the environment in a more human-like fashion. It also removes the burden from the maps designers of placing manually the navigation graph.

Our first evaluations tend to show that the growing neural gas gives a good representation of the environment. The learning is fast, with one demonstrator it takes up to 25 minutes to learn a representation of the whole environment. As it is possible to learn with several demonstrators, learning can be done very quickly.

The character can thus adapt quickly to changes in the use of the environment and evolve while playing. Although different runs gives different results, the representations are very similar.

With this ability to learn the environment, the agent can be placed in any simulation without a priori **knowledge and still be able to move by imitating human users.**
As the learning is quite fast, users could perceive the evolution in the way the agent acts and thus believing it can be human. The growing neural gas gives autonomy and believability to the model.

The next step is to put more information in the growing neural gas, learning which node is accessible from each node and finding the best action at each node. To see if this work really gives results we will have to test the difference in the behaviour between an agent using the navigation points and an agent using the growing neural gas.

## References

Bates J 1994 The Role of Emotion in Believable Agents Communications of the ACM 37**(7), 122–125.**

Bauckhage C, Gorman B, Thurau C and Humphrys M 2007 Learning Human Behavior from Analyzing Activities in Virtual Environments **MMI-Interaktiv**
12**, 3–17.**
Del Bimbo A., Vicario E. 1995 **Specification by-Example**
of Virtual Agents Behavior **IEEE Transactions on**
Visualization and Computer Graphics, Vol. 1, n. 4.

Fritzke B 1995 A growing neural gas network learns topologies in **'Advances in Neural Information Processing Systems 7' MIT Press pp. 625–632.**
Gorman B and Humphrys M 2007 Imitative learning of combat behaviours in first-person computer games in **'Proceedings of CGAMES 2007, the 11th International Conference on Computer Games: AI, Animation, Mobile, Educational & Serious Games'.**
Thurau C, Bauckhage C and Sagerer G 2004 Learning human-like movement behavior for computer games in **'Proceedings of the 8th International Conference on the Simulation of Adaptive Behavior**
(SAB'04)'.