Empirically, extensive results on scheduling problems in Fowler et al. (2005) have shown that ICP measure "evaluates the solution quality of approximation robustly (i.e., similar to visual comparison results) while other alternative measures can misjudge the solution quality".

In the next two sections 4 and 5, we investigate the problem of generating high quality plan sets for two cases mentioned: when no knowledge about the user's preferences is given, and when part of its is given as input to the planner.

## 4. Generating Diverse Plan Set In The Absence Of Preference Knowledge

In this section, we describe approaches to searching for a set of diverse plans with respect to a measure defined with base level elements of plans as discussed in the previous section. In particular, we consider the quality measure of plan set as the minimal pair-wise distance between any two plans, and generate a set of plans containing k plans with the quality of at least a predefined threshold d. As discussed earlier, by diversifying the set of plans on the space of base level features, it is likely that plans in the set would cover a wide range of space of unknown high level features, increasing the possibility that the user can select a plan close to the one that she prefers. The problem is formally defined as follows:
dDISTANTkSET : Find P with P ⊆ S, **| P |** = k and ζ(P**) = min**
p,q∈P
δ(**p, q**) ≥ d where any distance measure between two plans formalized in Section 3.1.1 can be used to implement δ(**p, p**′).

We now consider two representative state-of-the-art planning approaches in generating diverse plan sets. The first one is GP-CSP (Do and Kambhampati, 2001) representing constraintbased planning approaches, and the second one is LPG (Gerevini et al., 2003) that uses an efficient local-search based approach. We use GP-CSP to comparing the relation between different distance measures in diversifying plan sets. On the other hand, with LPG we stick to the actionbased distance measure, which is shown experimentally to be the most difficult measure to enforce diversity (see below), and investigate the scalability of heuristic approaches in generating diverse plans.

## 4.1. Finding Diverse Plan Set With Gp-Csp

The GP-CSP planner (Do and Kambhampati, 2001) converts Graphplan's planning graph into a CSP encoding, and solves it using a standard CSP solver. The solution of the encoding represents a valid plan for the original planning problem. In the encoding, the CSP variables correspond to the predicates that have to be achieved at different levels in the planning graph (different planning steps) and their possible values are the actions that can support the predicates. For each CSP variable representing a predicate p, there are two special values: i) ⊥: indicates that a predicate is not supported by any action and is *false* at a particular level/planning-step; ii) "noop":
indicates that the predicate is true at a given level i because it was made true at some previous level **j < i** and no other action deletes p between j and i. Constraints encode the relations between predicates and actions: 1) mutual exclusion relations between predicates and actions; and 2) the causal relationships between actions and their preconditions.