4.1.1. Adapting GP-CSP to Different Distance Metrics When the above planning encoding is solved by any standard CSP solver, it will return a solution containing h*var, value*i of the form {hx1, y1i, ...hxn, yni}. The collection of xi where yi 6= ⊥
represents the facts that are made true at different time steps (plan trajectory) and can be used as a basis for the *state-based* distance measure7; the set of (yi 6= ⊥)∧ (yi 6= **noop**) represents the set of actions in the plan and can be used for *action-based* distance measure; lastly, the assignments hxi, yii themselves represent the causal relations and can be used for the *causal-based* distance measure.

However, there are some technical difficulties we need to overcome before a specific distance measure between plans can be computed. First, the same action can be represented by different values in the domains of different variables. Consider a simple example in which there are two facts p and q, both supported by two actions a1 and a2. When setting up the CSP encoding, we assume that the CSP variables x1 and x2 are used to represent p and q. The domains for x1 and x2 are {v11, v12} and {v21, v22}, both representing the two actions {a1, a2} (in that order). The assignments {hx1, v11i,hx2, v21i} and {hx1, v12i,hx2, v22i} have a distance of 2 in traditional CSP because different values are assigned for each variable x1 and x2. However, they both represent the same action set {a1, a2} and thus lead to the plan distance of 0 if we use the actionbased distance in our plan comparison. Therefore, we first need to translate the set of values in all assignments back to the set of action instances before doing comparison using action-based distance. The second complication arises for the causal-based distance. A causal link a1p→ a2 between two actions a1 and a2 indicates that a1 supports the precondition p of a2. However, the CSP assignment h**p, a**1i only provides the first half of each causal-link. To complete the causallink, we need to look at the values of other CSP assignments to identify action a2 that occurs at the later level in the planning graph and has p as its precondition. Note that there may be multiple
"valid" sets of causal-links for a plan, and in the implementation we simply select causal-links based on the CSP assignments. 4.1.2. Making GP-CSP Return a Set of Plans To make GP-CSP return a set of plans satisfying the dDISTANTkSET constraint using one of the three distance measures, we add "global" constraints to each original encoding to enforce d-diversity between every pair of solutions. When each global constraint is called upon by the normal forward checking and arc-consistency checking procedures inside the default solver to check if the distance between two plans is over a predefined value d, we first map each set of assignments to an actual set of actions (action-based), predicates that are true at different plansteps (state-based) or causal-links (causal-based) using the method discussed in the previous section. This process is done by mapping all h**var, value**i CSP assignments into action sets using a call to the planning graph, which is outside of the CSP solver, but works closely with the general purpose CSP solver in GP-CSP. The comparison is then done within the implementation of the global constraint to decide if two solutions are diverse enough.

We investigate two different ways to use the global constraints:
1. The *parallel* strategy to return the set of k plans all at once. In this approach, we create one encoding that contains k identical copies of each original planning encoding created using GP-CSP planner. The k copies are connected together using k(k − 1)/2 pair-wise